/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.Union;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.BinaryUnionOpDescriptor;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public class BinaryUnionNode
extends TwoInputNode {
    private Set<RequestedGlobalProperties> channelProps;

    public BinaryUnionNode(Union<?> union) {
        super((DualInputOperator<?, ?, ?, ?>)union);
    }

    @Override
    public String getOperatorName() {
        return "Union";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return Collections.emptyList();
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        long card1 = this.getFirstPredecessorNode().getEstimatedNumRecords();
        long card2 = this.getSecondPredecessorNode().getEstimatedNumRecords();
        this.estimatedNumRecords = card1 < 0L || card2 < 0L ? -1L : card1 + card2;
        long size1 = this.getFirstPredecessorNode().getEstimatedOutputSize();
        long size2 = this.getSecondPredecessorNode().getEstimatedOutputSize();
        this.estimatedOutputSize = size1 < 0L || size2 < 0L ? -1L : size1 + size2;
    }

    @Override
    public void computeUnionOfInterestingPropertiesFromSuccessors() {
        super.computeUnionOfInterestingPropertiesFromSuccessors();
        this.getInterestingProperties().getLocalProperties().clear();
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties props = this.getInterestingProperties();
        if (props.getGlobalProperties().isEmpty()) {
            props.addGlobalProperties(new RequestedGlobalProperties());
        }
        props.addLocalProperties(new RequestedLocalProperties());
        this.input1.setInterestingProperties(props.clone());
        this.input2.setInterestingProperties(props.clone());
        this.channelProps = props.getGlobalProperties();
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        if (this.getOutgoingConnections().size() > 1) {
            throw new CompilerException("BinaryUnionNode has more than one successor.");
        }
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        List<PlanNode> subPlans1 = this.getFirstPredecessorNode().getAlternativePlans(estimator);
        List<PlanNode> subPlans2 = this.getSecondPredecessorNode().getAlternativePlans(estimator);
        List<DagConnection> broadcastConnections = this.getBroadcastConnections();
        if (broadcastConnections != null && broadcastConnections.size() > 0) {
            throw new CompilerException("Found BroadcastVariables on a Union operation");
        }
        ArrayList<PlanNode> outputPlans = new ArrayList<PlanNode>();
        List<Set<? extends NamedChannel>> broadcastPlanChannels = Collections.emptyList();
        BinaryUnionOpDescriptor operator = new BinaryUnionOpDescriptor();
        RequestedLocalProperties noLocalProps = new RequestedLocalProperties();
        ExecutionMode input1Mode = this.input1.getDataExchangeMode();
        ExecutionMode input2Mode = this.input2.getDataExchangeMode();
        int parallelism = this.getParallelism();
        int inParallelism1 = this.getFirstPredecessorNode().getParallelism();
        int inParallelism2 = this.getSecondPredecessorNode().getParallelism();
        boolean dopChange1 = parallelism != inParallelism1;
        boolean dopChange2 = parallelism != inParallelism2;
        boolean input1breakPipeline = this.input1.isBreakingPipeline();
        boolean input2breakPipeline = this.input2.isBreakingPipeline();
        for (PlanNode child1 : subPlans1) {
            for (PlanNode child2 : subPlans2) {
                if (!this.areBranchCompatible(child1, child2)) continue;
                for (RequestedGlobalProperties igps : this.channelProps) {
                    Channel c1 = new Channel(child1, this.input1.getMaterializationMode());
                    if (this.input1.getShipStrategy() == null) {
                        igps.parameterizeChannel(c1, dopChange1, input1Mode, input1breakPipeline);
                        if (dopChange1 && !c1.getShipStrategy().isNetworkStrategy()) {
                            c1.getGlobalProperties().reset();
                        }
                    } else {
                        ShipStrategyType shipStrategy = this.input1.getShipStrategy();
                        DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)input1Mode, (ShipStrategyType)shipStrategy, (boolean)input1breakPipeline);
                        if (this.keys1 != null) {
                            c1.setShipStrategy(this.input1.getShipStrategy(), this.keys1.toFieldList(), exMode);
                        } else {
                            c1.setShipStrategy(this.input1.getShipStrategy(), exMode);
                        }
                        if (dopChange1) {
                            c1.adjustGlobalPropertiesForFullParallelismChange();
                        }
                    }
                    Channel c2 = new Channel(child2, this.input2.getMaterializationMode());
                    if (this.input2.getShipStrategy() == null) {
                        igps.parameterizeChannel(c2, dopChange2, input2Mode, input2breakPipeline);
                        if (dopChange2 && !c2.getShipStrategy().isNetworkStrategy()) {
                            c2.getGlobalProperties().reset();
                        }
                    } else {
                        ShipStrategyType shipStrategy = this.input2.getShipStrategy();
                        DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)input2Mode, (ShipStrategyType)shipStrategy, (boolean)input2breakPipeline);
                        if (this.keys2 != null) {
                            c2.setShipStrategy(this.input2.getShipStrategy(), this.keys2.toFieldList(), exMode);
                        } else {
                            c2.setShipStrategy(this.input2.getShipStrategy(), exMode);
                        }
                        if (dopChange2) {
                            c2.adjustGlobalPropertiesForFullParallelismChange();
                        }
                    }
                    GlobalProperties p1 = c1.getGlobalProperties();
                    GlobalProperties p2 = c2.getGlobalProperties();
                    p1.clearUniqueFieldCombinations();
                    p2.clearUniqueFieldCombinations();
                    if (!igps.isTrivial() && !p1.equals(p2)) {
                        if (c1.getShipStrategy() == ShipStrategyType.FORWARD && c2.getShipStrategy() != ShipStrategyType.FORWARD) {
                            c2 = c2.clone();
                            p1.parameterizeChannel(c2, dopChange2, input2Mode, input2breakPipeline);
                        } else if (c2.getShipStrategy() == ShipStrategyType.FORWARD && c1.getShipStrategy() != ShipStrategyType.FORWARD) {
                            c1 = c1.clone();
                            p2.parameterizeChannel(c1, dopChange1, input1Mode, input1breakPipeline);
                        } else if (c1.getShipStrategy() == ShipStrategyType.FORWARD && c2.getShipStrategy() == ShipStrategyType.FORWARD) {
                            boolean adjustC1;
                            boolean bl = adjustC1 = c1.getEstimatedOutputSize() <= 0L || c2.getEstimatedOutputSize() <= 0L || c1.getEstimatedOutputSize() <= c2.getEstimatedOutputSize();
                            if (adjustC1) {
                                c2 = c2.clone();
                                p1.parameterizeChannel(c2, dopChange2, input2Mode, input2breakPipeline);
                            } else {
                                c1 = c1.clone();
                                p2.parameterizeChannel(c1, dopChange1, input1Mode, input1breakPipeline);
                            }
                        } else {
                            throw new CompilerException("Bug in Plan Enumeration for Union Node.");
                        }
                    }
                    this.instantiate(operator, c1, c2, broadcastPlanChannels, outputPlans, estimator, igps, igps, noLocalProps, noLocalProps);
                }
            }
        }
        for (PlanNode node : outputPlans) {
            estimator.costOperator(node);
        }
        this.prunePlanAlternatives(outputPlans);
        outputPlans.trimToSize();
        this.cachedPlans = outputPlans;
        return outputPlans;
    }

    @Override
    protected void readStubAnnotations() {
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return new UnionSemanticProperties();
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
        OptimizerNode in1 = this.getFirstPredecessorNode();
        OptimizerNode in2 = this.getSecondPredecessorNode();
        this.estimatedNumRecords = in1.estimatedNumRecords > 0L && in2.estimatedNumRecords > 0L ? in1.estimatedNumRecords + in2.estimatedNumRecords : -1L;
        this.estimatedOutputSize = in1.estimatedOutputSize > 0L && in2.estimatedOutputSize > 0L ? in1.estimatedOutputSize + in2.estimatedOutputSize : -1L;
    }

    public static class UnionSemanticProperties
    implements SemanticProperties {
        private static final long serialVersionUID = 1L;

        public FieldSet getForwardingTargetFields(int input, int sourceField) {
            if (input != 0 && input != 1) {
                throw new IndexOutOfBoundsException("Invalid input index for binary union node.");
            }
            return new FieldSet(Integer.valueOf(sourceField));
        }

        public int getForwardingSourceField(int input, int targetField) {
            if (input != 0 && input != 1) {
                throw new IndexOutOfBoundsException();
            }
            return targetField;
        }

        public FieldSet getReadFields(int input) {
            if (input != 0 && input != 1) {
                throw new IndexOutOfBoundsException();
            }
            return FieldSet.EMPTY_SET;
        }
    }
}

