/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.postpass;

import java.util.Map;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.CompilerPostPassException;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dag.WorksetIterationNode;
import org.apache.flink.optimizer.plan.BulkIterationPlanNode;
import org.apache.flink.optimizer.plan.BulkPartialSolutionPlanNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.NAryUnionPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plan.SolutionSetPlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.apache.flink.optimizer.plan.WorksetIterationPlanNode;
import org.apache.flink.optimizer.plan.WorksetPlanNode;
import org.apache.flink.optimizer.postpass.AbstractSchema;
import org.apache.flink.optimizer.postpass.ConflictingFieldTypeInfoException;
import org.apache.flink.optimizer.postpass.MissingFieldTypeInfoException;
import org.apache.flink.optimizer.postpass.OptimizerPostPass;

public abstract class GenericFlatTypePostPass<X, T extends AbstractSchema<X>>
implements OptimizerPostPass {
    private boolean propagateParentSchemaDown = true;

    public boolean isPropagateParentSchemaDown() {
        return this.propagateParentSchemaDown;
    }

    public void setPropagateParentSchemaDown(boolean propagateParentSchemaDown) {
        this.propagateParentSchemaDown = propagateParentSchemaDown;
    }

    @Override
    public void postPass(OptimizedPlan plan) {
        for (SinkPlanNode sink : plan.getDataSinks()) {
            this.traverse(sink, null, true);
        }
    }

    protected void traverse(PlanNode node, T parentSchema, boolean createUtilities) {
        if (node instanceof SinkPlanNode) {
            SinkPlanNode sn = (SinkPlanNode)node;
            Channel inchannel = sn.getInput();
            T schema = this.createEmptySchema();
            sn.postPassHelper = schema;
            try {
                this.getSinkSchema(sn, schema);
            }
            catch (ConflictingFieldTypeInfoException e) {
                throw new CompilerPostPassException("Conflicting type infomation for the data sink '" + sn.getSinkNode().getOperator().getName() + "'.");
            }
            try {
                this.propagateToChannel(schema, inchannel, createUtilities);
            }
            catch (MissingFieldTypeInfoException ex) {
                throw new CompilerPostPassException("Missing type infomation for the channel that inputs to the data sink '" + sn.getSinkNode().getOperator().getName() + "'.");
            }
        }
        if (node instanceof SourcePlanNode) {
            if (createUtilities) {
                ((SourcePlanNode)node).setSerializer(this.createSerializer(parentSchema, node));
            }
        } else {
            if (node instanceof BulkIterationPlanNode) {
                Object schema;
                BulkIterationPlanNode iterationNode = (BulkIterationPlanNode)node;
                if (iterationNode.postPassHelper == null) {
                    iterationNode.postPassHelper = schema = this.createEmptySchema();
                } else {
                    schema = (AbstractSchema)iterationNode.postPassHelper;
                }
                ((AbstractSchema)schema).increaseNumConnectionsThatContributed();
                if (this.propagateParentSchemaDown) {
                    this.addSchemaToSchema(parentSchema, schema, iterationNode.getProgramOperator().getName());
                }
                if (((AbstractSchema)schema).getNumConnectionsThatContributed() < iterationNode.getOutgoingChannels().size()) {
                    return;
                }
                if (iterationNode.getRootOfStepFunction() instanceof NAryUnionPlanNode) {
                    throw new CompilerException("Optimizer cannot compile an iteration step function where next partial solution is created by a Union node.");
                }
                if (iterationNode.getRootOfTerminationCriterion() != null) {
                    SingleInputPlanNode addMapper = (SingleInputPlanNode)iterationNode.getRootOfTerminationCriterion();
                    this.traverse(addMapper.getInput().getSource(), this.createEmptySchema(), false);
                    try {
                        addMapper.getInput().setSerializer(this.createSerializer(this.createEmptySchema()));
                    }
                    catch (MissingFieldTypeInfoException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.traverse(iterationNode.getRootOfStepFunction(), schema, false);
                AbstractSchema pss = (AbstractSchema)iterationNode.getPartialSolutionPlanNode().postPassHelper;
                if (pss == null) {
                    throw new CompilerException("Error in Optimizer Post Pass: Partial solution schema is null after first traversal of the step function.");
                }
                this.traverse(iterationNode.getRootOfStepFunction(), pss, createUtilities);
                if (iterationNode.getRootOfTerminationCriterion() != null) {
                    SingleInputPlanNode addMapper = (SingleInputPlanNode)iterationNode.getRootOfTerminationCriterion();
                    this.traverse(addMapper.getInput().getSource(), this.createEmptySchema(), createUtilities);
                    try {
                        addMapper.getInput().setSerializer(this.createSerializer(this.createEmptySchema()));
                    }
                    catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                        throw new RuntimeException(missingFieldTypeInfoException);
                    }
                }
                this.addSchemaToSchema(pss, schema, iterationNode.getProgramOperator().getName());
                if (createUtilities) {
                    iterationNode.setSerializerForIterationChannel(this.createSerializer(pss, iterationNode.getPartialSolutionPlanNode()));
                }
                try {
                    this.propagateToChannel(schema, iterationNode.getInput(), createUtilities);
                }
                catch (MissingFieldTypeInfoException e) {
                    throw new CompilerPostPassException("Could not set up runtime strategy for input channel to node '" + iterationNode.getProgramOperator().getName() + "'. Missing type information for key field " + e.getFieldNumber());
                }
            }
            if (node instanceof WorksetIterationPlanNode) {
                Object schema;
                WorksetIterationPlanNode iterationNode = (WorksetIterationPlanNode)node;
                if (iterationNode.postPassHelper == null) {
                    iterationNode.postPassHelper = schema = this.createEmptySchema();
                } else {
                    schema = (AbstractSchema)iterationNode.postPassHelper;
                }
                ((AbstractSchema)schema).increaseNumConnectionsThatContributed();
                if (this.propagateParentSchemaDown) {
                    this.addSchemaToSchema(parentSchema, schema, iterationNode.getProgramOperator().getName());
                }
                if (((AbstractSchema)schema).getNumConnectionsThatContributed() < iterationNode.getOutgoingChannels().size()) {
                    return;
                }
                if (iterationNode.getNextWorkSetPlanNode() instanceof NAryUnionPlanNode) {
                    throw new CompilerException("Optimizer cannot compile a workset iteration step function where the next workset is produced by a Union node.");
                }
                if (iterationNode.getSolutionSetDeltaPlanNode() instanceof NAryUnionPlanNode) {
                    throw new CompilerException("Optimizer cannot compile a workset iteration step function where the solution set delta is produced by a Union node.");
                }
                this.traverse(iterationNode.getNextWorkSetPlanNode(), this.createEmptySchema(), false);
                this.traverse(iterationNode.getSolutionSetDeltaPlanNode(), schema, false);
                AbstractSchema wss = (AbstractSchema)iterationNode.getWorksetPlanNode().postPassHelper;
                AbstractSchema sss = (AbstractSchema)iterationNode.getSolutionSetPlanNode().postPassHelper;
                if (wss == null) {
                    throw new CompilerException("Error in Optimizer Post Pass: Workset schema is null after first traversal of the step function.");
                }
                if (sss == null) {
                    throw new CompilerException("Error in Optimizer Post Pass: Solution set schema is null after first traversal of the step function.");
                }
                this.traverse(iterationNode.getNextWorkSetPlanNode(), wss, createUtilities);
                this.traverse(iterationNode.getSolutionSetDeltaPlanNode(), sss, createUtilities);
                try {
                    for (Map.Entry entry : sss) {
                        Integer pos = (Integer)entry.getKey();
                        ((AbstractSchema)schema).addType(pos, entry.getValue());
                    }
                }
                catch (ConflictingFieldTypeInfoException conflictingFieldTypeInfoException) {
                    throw new CompilerPostPassException("Conflicting type information for field " + conflictingFieldTypeInfoException.getFieldNumber() + " in node '" + iterationNode.getProgramOperator().getName() + "'. Contradicting types between the result of the iteration and the solution set schema: " + conflictingFieldTypeInfoException.getPreviousType() + " and " + conflictingFieldTypeInfoException.getNewType() + ". Most probable cause: Invalid constant field annotations.");
                }
                if (createUtilities) {
                    WorksetIterationNode worksetIterationNode = iterationNode.getIterationNode();
                    iterationNode.setWorksetSerializer(this.createSerializer(wss, iterationNode.getWorksetPlanNode()));
                    iterationNode.setSolutionSetSerializer(this.createSerializer(sss, iterationNode.getSolutionSetPlanNode()));
                    try {
                        iterationNode.setSolutionSetComparator(this.createComparator(worksetIterationNode.getSolutionSetKeyFields(), null, sss));
                    }
                    catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                        throw new CompilerPostPassException("Could not set up the solution set for workset iteration '" + worksetIterationNode.getOperator().getName() + "'. Missing type information for key field " + missingFieldTypeInfoException.getFieldNumber() + '.');
                    }
                }
                try {
                    this.propagateToChannel(schema, iterationNode.getInitialSolutionSetInput(), createUtilities);
                    this.propagateToChannel(wss, iterationNode.getInitialWorksetInput(), createUtilities);
                }
                catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                    throw new CompilerPostPassException("Could not set up runtime strategy for input channel to node '" + iterationNode.getProgramOperator().getName() + "'. Missing type information for key field " + missingFieldTypeInfoException.getFieldNumber());
                }
            }
            if (node instanceof SingleInputPlanNode) {
                Object schema;
                SingleInputPlanNode sn = (SingleInputPlanNode)node;
                if (sn.postPassHelper == null) {
                    sn.postPassHelper = schema = this.createEmptySchema();
                } else {
                    schema = (AbstractSchema)sn.postPassHelper;
                }
                ((AbstractSchema)schema).increaseNumConnectionsThatContributed();
                SingleInputNode optNode = sn.getSingleInputNode();
                if (this.propagateParentSchemaDown) {
                    this.addSchemaToSchema(parentSchema, schema, optNode, 0);
                }
                if (((AbstractSchema)schema).getNumConnectionsThatContributed() < sn.getOutgoingChannels().size()) {
                    return;
                }
                try {
                    this.getSingleInputNodeSchema(sn, schema);
                }
                catch (ConflictingFieldTypeInfoException e) {
                    throw new CompilerPostPassException(this.getConflictingTypeErrorMessage(e, optNode.getOperator().getName()));
                }
                if (createUtilities) {
                    for (int i = 0; i < sn.getDriverStrategy().getNumRequiredComparators(); ++i) {
                        try {
                            sn.setComparator(this.createComparator(sn.getKeys(i), sn.getSortOrders(i), schema), i);
                            continue;
                        }
                        catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                            throw new CompilerPostPassException("Could not set up runtime strategy for node '" + optNode.getOperator().getName() + "'. Missing type information for key field " + missingFieldTypeInfoException.getFieldNumber());
                        }
                    }
                }
                try {
                    this.propagateToChannel(schema, sn.getInput(), createUtilities);
                }
                catch (MissingFieldTypeInfoException e) {
                    throw new CompilerPostPassException("Could not set up runtime strategy for input channel to node '" + optNode.getOperator().getName() + "'. Missing type information for field " + e.getFieldNumber());
                }
                for (Channel channel : sn.getBroadcastInputs()) {
                    try {
                        this.propagateToChannel(this.createEmptySchema(), channel, createUtilities);
                    }
                    catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                        throw new CompilerPostPassException("Could not set up runtime strategy for broadcast channel in node '" + optNode.getOperator().getName() + "'. Missing type information for field " + missingFieldTypeInfoException.getFieldNumber());
                    }
                }
            } else if (node instanceof DualInputPlanNode) {
                Object schema2;
                Object schema1;
                DualInputPlanNode dn = (DualInputPlanNode)node;
                if (dn.postPassHelper1 == null) {
                    schema1 = this.createEmptySchema();
                    schema2 = this.createEmptySchema();
                    dn.postPassHelper1 = schema1;
                    dn.postPassHelper2 = schema2;
                } else {
                    schema1 = (AbstractSchema)dn.postPassHelper1;
                    schema2 = (AbstractSchema)dn.postPassHelper2;
                }
                ((AbstractSchema)schema1).increaseNumConnectionsThatContributed();
                ((AbstractSchema)schema2).increaseNumConnectionsThatContributed();
                TwoInputNode optNode = dn.getTwoInputNode();
                if (this.propagateParentSchemaDown) {
                    this.addSchemaToSchema(parentSchema, schema1, optNode, 0);
                    this.addSchemaToSchema(parentSchema, schema2, optNode, 1);
                }
                if (((AbstractSchema)schema1).getNumConnectionsThatContributed() < dn.getOutgoingChannels().size()) {
                    return;
                }
                try {
                    this.getDualInputNodeSchema(dn, schema1, schema2);
                }
                catch (ConflictingFieldTypeInfoException conflictingFieldTypeInfoException) {
                    throw new CompilerPostPassException(this.getConflictingTypeErrorMessage(conflictingFieldTypeInfoException, optNode.getOperator().getName()));
                }
                if (createUtilities && dn.getDriverStrategy().getNumRequiredComparators() > 0) {
                    try {
                        dn.setComparator1(this.createComparator(dn.getKeysForInput1(), dn.getSortOrders(), schema1));
                        dn.setComparator2(this.createComparator(dn.getKeysForInput2(), dn.getSortOrders(), schema2));
                    }
                    catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                        throw new CompilerPostPassException("Could not set up runtime strategy for node '" + optNode.getOperator().getName() + "'. Missing type information for field " + missingFieldTypeInfoException.getFieldNumber());
                    }
                    try {
                        dn.setPairComparator(this.createPairComparator(dn.getKeysForInput1(), dn.getKeysForInput2(), dn.getSortOrders(), schema1, schema2));
                    }
                    catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                        throw new CompilerPostPassException("Could not set up runtime strategy for node '" + optNode.getOperator().getName() + "'. Missing type information for field " + missingFieldTypeInfoException.getFieldNumber());
                    }
                }
                try {
                    this.propagateToChannel(schema1, dn.getInput1(), createUtilities);
                }
                catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                    throw new CompilerPostPassException("Could not set up runtime strategy for the first input channel to node '" + optNode.getOperator().getName() + "'. Missing type information for field " + missingFieldTypeInfoException.getFieldNumber());
                }
                try {
                    this.propagateToChannel(schema2, dn.getInput2(), createUtilities);
                }
                catch (MissingFieldTypeInfoException missingFieldTypeInfoException) {
                    throw new CompilerPostPassException("Could not set up runtime strategy for the second input channel to node '" + optNode.getOperator().getName() + "'. Missing type information for field " + missingFieldTypeInfoException.getFieldNumber());
                }
                for (Channel channel : dn.getBroadcastInputs()) {
                    try {
                        this.propagateToChannel(this.createEmptySchema(), channel, createUtilities);
                    }
                    catch (MissingFieldTypeInfoException e) {
                        throw new CompilerPostPassException("Could not set up runtime strategy for broadcast channel in node '" + optNode.getOperator().getName() + "'. Missing type information for field " + e.getFieldNumber());
                    }
                }
            } else if (node instanceof NAryUnionPlanNode) {
                try {
                    for (Channel channel : node.getInputs()) {
                        this.propagateToChannel(parentSchema, channel, createUtilities);
                    }
                }
                catch (MissingFieldTypeInfoException ex) {
                    throw new CompilerPostPassException("Could not set up runtime strategy for the input channel to  a union node. Missing type information for field " + ex.getFieldNumber());
                }
            } else if (node instanceof BulkPartialSolutionPlanNode || node instanceof SolutionSetPlanNode || node instanceof WorksetPlanNode) {
                String name;
                Object schema;
                if (node instanceof BulkPartialSolutionPlanNode) {
                    BulkPartialSolutionPlanNode psn = (BulkPartialSolutionPlanNode)node;
                    if (psn.postPassHelper == null) {
                        psn.postPassHelper = schema = this.createEmptySchema();
                    } else {
                        schema = (AbstractSchema)psn.postPassHelper;
                    }
                    name = "partial solution of bulk iteration '" + psn.getPartialSolutionNode().getIterationNode().getOperator().getName() + "'";
                } else if (node instanceof SolutionSetPlanNode) {
                    SolutionSetPlanNode ssn = (SolutionSetPlanNode)node;
                    if (ssn.postPassHelper == null) {
                        ssn.postPassHelper = schema = this.createEmptySchema();
                    } else {
                        schema = (AbstractSchema)ssn.postPassHelper;
                    }
                    name = "solution set of workset iteration '" + ssn.getSolutionSetNode().getIterationNode().getOperator().getName() + "'";
                } else if (node instanceof WorksetPlanNode) {
                    WorksetPlanNode wsn = (WorksetPlanNode)node;
                    if (wsn.postPassHelper == null) {
                        wsn.postPassHelper = schema = this.createEmptySchema();
                    } else {
                        schema = (AbstractSchema)wsn.postPassHelper;
                    }
                    name = "workset of workset iteration '" + wsn.getWorksetNode().getIterationNode().getOperator().getName() + "'";
                } else {
                    throw new CompilerException();
                }
                ((AbstractSchema)schema).increaseNumConnectionsThatContributed();
                this.addSchemaToSchema(parentSchema, schema, name);
            } else {
                throw new CompilerPostPassException("Unknown node type encountered: " + node.getClass().getName());
            }
        }
    }

    private void propagateToChannel(T schema, Channel channel, boolean createUtilities) throws MissingFieldTypeInfoException {
        if (createUtilities) {
            channel.setSerializer(this.createSerializer(schema));
            if (channel.getShipStrategy().requiresComparator()) {
                channel.setShipStrategyComparator(this.createComparator(channel.getShipStrategyKeys(), channel.getShipStrategySortOrder(), schema));
            }
            if (channel.getLocalStrategy().requiresComparator()) {
                channel.setLocalStrategyComparator(this.createComparator(channel.getLocalStrategyKeys(), channel.getLocalStrategySortOrder(), schema));
            }
        }
        this.traverse(channel.getSource(), schema, createUtilities);
    }

    private void addSchemaToSchema(T sourceSchema, T targetSchema, String opName) {
        try {
            for (Map.Entry entry : sourceSchema) {
                Integer pos = (Integer)entry.getKey();
                ((AbstractSchema)targetSchema).addType(pos, entry.getValue());
            }
        }
        catch (ConflictingFieldTypeInfoException e) {
            throw new CompilerPostPassException("Conflicting type information for field " + e.getFieldNumber() + " in node '" + opName + "' propagated from successor node. Conflicting types: " + e.getPreviousType() + " and " + e.getNewType() + ". Most probable cause: Invalid constant field annotations.");
        }
    }

    private void addSchemaToSchema(T sourceSchema, T targetSchema, OptimizerNode optNode, int input) {
        try {
            for (Map.Entry entry : sourceSchema) {
                Integer pos = (Integer)entry.getKey();
                SemanticProperties sprops = optNode.getSemanticProperties();
                if (sprops == null || sprops.getForwardingTargetFields(input, pos.intValue()) == null || !sprops.getForwardingTargetFields(input, pos.intValue()).contains(pos)) continue;
                ((AbstractSchema)targetSchema).addType(pos, entry.getValue());
            }
        }
        catch (ConflictingFieldTypeInfoException e) {
            throw new CompilerPostPassException("Conflicting type information for field " + e.getFieldNumber() + " in node '" + optNode.getOperator().getName() + "' propagated from successor node. Conflicting types: " + e.getPreviousType() + " and " + e.getNewType() + ". Most probable cause: Invalid constant field annotations.");
        }
    }

    private String getConflictingTypeErrorMessage(ConflictingFieldTypeInfoException e, String operatorName) {
        return "Conflicting type information for field " + e.getFieldNumber() + " in node '" + operatorName + "' between types declared in the node's contract and types inferred from successor contracts. Conflicting types: " + e.getPreviousType() + " and " + e.getNewType() + ". Most probable cause: Invalid constant field annotations.";
    }

    private TypeSerializerFactory<?> createSerializer(T schema, PlanNode node) {
        try {
            return this.createSerializer(schema);
        }
        catch (MissingFieldTypeInfoException e) {
            throw new CompilerPostPassException("Missing type information while creating serializer for '" + node.getProgramOperator().getName() + "'.");
        }
    }

    protected abstract T createEmptySchema();

    protected abstract void getSinkSchema(SinkPlanNode var1, T var2) throws CompilerPostPassException, ConflictingFieldTypeInfoException;

    protected abstract void getSingleInputNodeSchema(SingleInputPlanNode var1, T var2) throws CompilerPostPassException, ConflictingFieldTypeInfoException;

    protected abstract void getDualInputNodeSchema(DualInputPlanNode var1, T var2, T var3) throws CompilerPostPassException, ConflictingFieldTypeInfoException;

    protected abstract TypeSerializerFactory<?> createSerializer(T var1) throws MissingFieldTypeInfoException;

    protected abstract TypeComparatorFactory<?> createComparator(FieldList var1, boolean[] var2, T var3) throws MissingFieldTypeInfoException;

    protected abstract TypePairComparatorFactory<?, ?> createPairComparator(FieldList var1, FieldList var2, boolean[] var3, T var4, T var5) throws MissingFieldTypeInfoException;
}

