/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.util.Utils;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalProperties
implements Cloneable {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalProperties.class);
    private PartitioningProperty partitioning = PartitioningProperty.RANDOM_PARTITIONED;
    private FieldList partitioningFields;
    private Ordering ordering;
    private Set<FieldSet> uniqueFieldCombinations;
    private Partitioner<?> customPartitioner;
    private DataDistribution distribution;

    public void setHashPartitioned(FieldList partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.HASH_PARTITIONED;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRangePartitioned(Ordering ordering) {
        if (ordering == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.RANGE_PARTITIONED;
        this.ordering = ordering;
        this.partitioningFields = ordering.getInvolvedIndexes();
    }

    public void setRangePartitioned(Ordering ordering, DataDistribution distribution) {
        if (ordering == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.RANGE_PARTITIONED;
        this.ordering = ordering;
        this.partitioningFields = ordering.getInvolvedIndexes();
        this.distribution = distribution;
    }

    public void setAnyPartitioning(FieldList partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.ANY_PARTITIONING;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRandomPartitioned() {
        this.partitioning = PartitioningProperty.RANDOM_PARTITIONED;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setFullyReplicated() {
        this.partitioning = PartitioningProperty.FULL_REPLICATION;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setForcedRebalanced() {
        this.partitioning = PartitioningProperty.FORCED_REBALANCED;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setCustomPartitioned(FieldList partitionedFields, Partitioner<?> partitioner) {
        if (partitionedFields == null || partitioner == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.CUSTOM_PARTITIONING;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
        this.customPartitioner = partitioner;
    }

    public void addUniqueFieldCombination(FieldSet fields) {
        if (fields == null) {
            return;
        }
        if (this.uniqueFieldCombinations == null) {
            this.uniqueFieldCombinations = new HashSet<FieldSet>();
        }
        this.uniqueFieldCombinations.add(fields);
    }

    public void clearUniqueFieldCombinations() {
        if (this.uniqueFieldCombinations != null) {
            this.uniqueFieldCombinations = null;
        }
    }

    public Set<FieldSet> getUniqueFieldCombination() {
        return this.uniqueFieldCombinations;
    }

    public FieldList getPartitioningFields() {
        return this.partitioningFields;
    }

    public Ordering getPartitioningOrdering() {
        return this.ordering;
    }

    public PartitioningProperty getPartitioning() {
        return this.partitioning;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    public DataDistribution getDataDistribution() {
        return this.distribution;
    }

    public boolean isPartitionedOnFields(FieldSet fields) {
        if (this.partitioning.isPartitionedOnKey() && fields.isValidSubset((FieldSet)this.partitioningFields)) {
            return true;
        }
        if (this.uniqueFieldCombinations != null) {
            for (FieldSet set : this.uniqueFieldCombinations) {
                if (!fields.isValidSubset(set)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isExactlyPartitionedOnFields(FieldList fields) {
        return this.partitioning.isPartitionedOnKey() && fields.isExactMatch(this.partitioningFields);
    }

    public boolean matchesOrderedPartitioning(Ordering o) {
        if (this.partitioning == PartitioningProperty.RANGE_PARTITIONED) {
            if (this.ordering.getNumberOfFields() > o.getNumberOfFields()) {
                return false;
            }
            for (int i = 0; i < this.ordering.getNumberOfFields(); ++i) {
                if (!this.ordering.getFieldNumber(i).equals(o.getFieldNumber(i))) {
                    return false;
                }
                Order oo = o.getOrder(i);
                Order to = this.ordering.getOrder(i);
                if (oo == Order.NONE || !(oo == Order.ANY ? to == Order.NONE : oo != to)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isFullyReplicated() {
        return this.partitioning == PartitioningProperty.FULL_REPLICATION;
    }

    public boolean isTrivial() {
        return this.partitioning == PartitioningProperty.RANDOM_PARTITIONED;
    }

    public void reset() {
        this.partitioning = PartitioningProperty.RANDOM_PARTITIONED;
        this.ordering = null;
        this.partitioningFields = null;
    }

    public GlobalProperties filterBySemanticProperties(SemanticProperties props, int input) {
        if (props == null) {
            throw new NullPointerException("SemanticProperties may not be null.");
        }
        GlobalProperties gp = new GlobalProperties();
        switch (this.partitioning) {
            case RANGE_PARTITIONED: {
                Ordering newOrdering = new Ordering();
                for (int i = 0; i < this.ordering.getInvolvedIndexes().size(); ++i) {
                    int sourceField = this.ordering.getInvolvedIndexes().get(i);
                    FieldSet targetField = props.getForwardingTargetFields(input, sourceField);
                    if (targetField == null || targetField.size() == 0) {
                        newOrdering = null;
                        break;
                    }
                    if (targetField.size() > 1) {
                        LOG.warn("Found that a field is forwarded to more than one target field in semantic forwarded field information. Will only use the field with the lowest index.");
                    }
                    newOrdering.appendOrdering(Integer.valueOf(targetField.toArray()[0]), this.ordering.getType(i), this.ordering.getOrder(i));
                }
                if (newOrdering == null) break;
                gp.partitioning = PartitioningProperty.RANGE_PARTITIONED;
                gp.ordering = newOrdering;
                gp.partitioningFields = newOrdering.getInvolvedIndexes();
                gp.distribution = this.distribution;
                break;
            }
            case HASH_PARTITIONED: 
            case ANY_PARTITIONING: 
            case CUSTOM_PARTITIONING: {
                FieldList newPartitioningFields = new FieldList();
                Iterator i$ = this.partitioningFields.iterator();
                while (i$.hasNext()) {
                    int sourceField = (Integer)i$.next();
                    FieldSet targetField = props.getForwardingTargetFields(input, sourceField);
                    if (targetField == null || targetField.size() == 0) {
                        newPartitioningFields = null;
                        break;
                    }
                    if (targetField.size() > 1) {
                        LOG.warn("Found that a field is forwarded to more than one target field in semantic forwarded field information. Will only use the field with the lowest index.");
                    }
                    newPartitioningFields = newPartitioningFields.addField(Integer.valueOf(targetField.toArray()[0]));
                }
                if (newPartitioningFields == null) break;
                gp.partitioning = this.partitioning;
                gp.partitioningFields = newPartitioningFields;
                gp.customPartitioner = this.customPartitioner;
                break;
            }
            case FORCED_REBALANCED: 
            case FULL_REPLICATION: 
            case RANDOM_PARTITIONED: {
                gp.partitioning = this.partitioning;
                break;
            }
            default: {
                throw new RuntimeException("Unknown partitioning type.");
            }
        }
        if (this.uniqueFieldCombinations != null) {
            HashSet<FieldSet> newUniqueFieldCombinations = new HashSet<FieldSet>();
            for (FieldSet fieldCombo : this.uniqueFieldCombinations) {
                FieldSet newFieldCombo = new FieldSet();
                for (Integer sourceField : fieldCombo) {
                    FieldSet targetField = props.getForwardingTargetFields(input, sourceField.intValue());
                    if (targetField == null || targetField.size() == 0) {
                        newFieldCombo = null;
                        break;
                    }
                    if (targetField.size() > 1) {
                        LOG.warn("Found that a field is forwarded to more than one target field in semantic forwarded field information. Will only use the field with the lowest index.");
                    }
                    newFieldCombo = newFieldCombo.addField(Integer.valueOf(targetField.toArray()[0]));
                }
                if (newFieldCombo == null) continue;
                newUniqueFieldCombinations.add(newFieldCombo);
            }
            if (!newUniqueFieldCombinations.isEmpty()) {
                gp.uniqueFieldCombinations = newUniqueFieldCombinations;
            }
        }
        return gp;
    }

    public void parameterizeChannel(Channel channel, boolean globalDopChange, ExecutionMode exchangeMode, boolean breakPipeline) {
        Partitioner<?> partitioner;
        boolean[] sortDirection;
        FieldList partitionKeys;
        ShipStrategyType shipType;
        switch (this.partitioning) {
            case RANDOM_PARTITIONED: {
                shipType = globalDopChange ? ShipStrategyType.PARTITION_RANDOM : ShipStrategyType.FORWARD;
                partitionKeys = null;
                sortDirection = null;
                partitioner = null;
                break;
            }
            case FULL_REPLICATION: {
                shipType = ShipStrategyType.BROADCAST;
                partitionKeys = null;
                sortDirection = null;
                partitioner = null;
                break;
            }
            case HASH_PARTITIONED: 
            case ANY_PARTITIONING: {
                shipType = ShipStrategyType.PARTITION_HASH;
                partitionKeys = Utils.createOrderedFromSet((FieldSet)this.partitioningFields);
                sortDirection = null;
                partitioner = null;
                break;
            }
            case RANGE_PARTITIONED: {
                shipType = ShipStrategyType.PARTITION_RANGE;
                partitionKeys = this.ordering.getInvolvedIndexes();
                sortDirection = this.ordering.getFieldSortDirections();
                partitioner = null;
                break;
            }
            case FORCED_REBALANCED: {
                shipType = ShipStrategyType.PARTITION_RANDOM;
                partitionKeys = null;
                sortDirection = null;
                partitioner = null;
                break;
            }
            case CUSTOM_PARTITIONING: {
                shipType = ShipStrategyType.PARTITION_CUSTOM;
                partitionKeys = this.partitioningFields;
                sortDirection = null;
                partitioner = this.customPartitioner;
                break;
            }
            default: {
                throw new CompilerException("Unsupported partitioning strategy");
            }
        }
        channel.setDataDistribution(this.distribution);
        DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)exchangeMode, (ShipStrategyType)shipType, (boolean)breakPipeline);
        channel.setShipStrategy(shipType, partitionKeys, sortDirection, partitioner, exMode);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partitioning == null ? 0 : this.partitioning.ordinal());
        result = 31 * result + (this.partitioningFields == null ? 0 : this.partitioningFields.hashCode());
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GlobalProperties) {
            GlobalProperties other = (GlobalProperties)obj;
            return this.partitioning == other.partitioning && (this.ordering == other.ordering || this.ordering != null && this.ordering.equals((Object)other.ordering)) && (this.partitioningFields == other.partitioningFields || this.partitioningFields != null && this.partitioningFields.equals((Object)other.partitioningFields)) && (this.uniqueFieldCombinations == other.uniqueFieldCombinations || this.uniqueFieldCombinations != null && this.uniqueFieldCombinations.equals(other.uniqueFieldCombinations));
        }
        return false;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("GlobalProperties [partitioning=" + (Object)((Object)this.partitioning) + (this.partitioningFields == null ? "" : ", on fields " + this.partitioningFields) + (this.ordering == null ? "" : ", with ordering " + this.ordering));
        if (this.uniqueFieldCombinations == null) {
            bld.append(']');
        } else {
            bld.append(" - Unique field groups: ");
            bld.append(this.uniqueFieldCombinations);
            bld.append(']');
        }
        return bld.toString();
    }

    public GlobalProperties clone() {
        GlobalProperties newProps = new GlobalProperties();
        newProps.partitioning = this.partitioning;
        newProps.partitioningFields = this.partitioningFields;
        newProps.ordering = this.ordering;
        newProps.distribution = this.distribution;
        newProps.customPartitioner = this.customPartitioner;
        newProps.uniqueFieldCombinations = this.uniqueFieldCombinations == null ? null : new HashSet<FieldSet>(this.uniqueFieldCombinations);
        return newProps;
    }

    public static GlobalProperties combine(GlobalProperties gp1, GlobalProperties gp2) {
        if (gp1.isFullyReplicated()) {
            if (gp2.isFullyReplicated()) {
                return new GlobalProperties();
            }
            return gp2;
        }
        if (gp2.isFullyReplicated()) {
            return gp1;
        }
        if (gp1.ordering != null) {
            return gp1;
        }
        if (gp2.ordering != null) {
            return gp2;
        }
        if (gp1.partitioningFields != null) {
            return gp1;
        }
        if (gp2.partitioningFields != null) {
            return gp2;
        }
        if (gp1.uniqueFieldCombinations != null) {
            return gp1;
        }
        if (gp2.uniqueFieldCombinations != null) {
            return gp2;
        }
        if (gp1.getPartitioning().isPartitioned()) {
            return gp1;
        }
        if (gp2.getPartitioning().isPartitioned()) {
            return gp2;
        }
        return gp1;
    }
}

