/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobCache;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.TestingFailingBlobServer;
import org.junit.Assert;
import org.junit.Test;

public class BlobCacheRetriesTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobFetchRetries() {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        TestingFailingBlobServer server = null;
        BlobCache cache = null;
        try {
            BlobKey key;
            Configuration config = new Configuration();
            server = new TestingFailingBlobServer(config, 2);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            try (BlobClient blobClient = null;){
                blobClient = new BlobClient(serverAddress);
                key = blobClient.put(data);
            }
            cache = new BlobCache(serverAddress, config);
            URL url = cache.getURL(key);
            try (InputStream is = url.openStream();){
                byte[] received = new byte[data.length];
                Assert.assertEquals((long)data.length, (long)is.read(received));
                Assert.assertArrayEquals((byte[])data, (byte[])received);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cache != null) {
                cache.shutdown();
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobFetchWithTooManyFailures() {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        TestingFailingBlobServer server = null;
        BlobCache cache = null;
        try {
            BlobKey key;
            Configuration config = new Configuration();
            server = new TestingFailingBlobServer(config, 10);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            try (BlobClient blobClient = null;){
                blobClient = new BlobClient(serverAddress);
                key = blobClient.put(data);
            }
            cache = new BlobCache(serverAddress, config);
            try {
                cache.getURL(key);
                Assert.fail((String)"This should fail");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cache != null) {
                cache.shutdown();
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }
}

