/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobCache;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.junit.Assert;
import org.junit.Test;

public class BlobCacheSuccessTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobCache() {
        byte[] buf = new byte[128];
        ArrayList<BlobKey> blobKeys = new ArrayList<BlobKey>(2);
        BlobServer blobServer = null;
        BlobCache blobCache = null;
        try {
            blobServer = new BlobServer(new Configuration());
            InetSocketAddress serverAddress = new InetSocketAddress(blobServer.getPort());
            try (BlobClient blobClient = null;){
                blobClient = new BlobClient(serverAddress);
                blobKeys.add(blobClient.put(buf));
                buf[0] = 1;
                blobKeys.add(blobClient.put(buf));
            }
            blobCache = new BlobCache(serverAddress, new Configuration());
            for (BlobKey blobKey : blobKeys) {
                blobCache.getURL(blobKey);
            }
            blobServer.shutdown();
            blobServer = null;
            URL[] urls = new URL[blobKeys.size()];
            for (int i = 0; i < blobKeys.size(); ++i) {
                urls[i] = blobCache.getURL((BlobKey)blobKeys.get(i));
            }
            Assert.assertEquals((long)blobKeys.size(), (long)urls.length);
            for (URL url : urls) {
                Assert.assertNotNull((Object)url);
                try {
                    File cachedFile = new File(url.toURI());
                    Assert.assertTrue((boolean)cachedFile.exists());
                    Assert.assertEquals((long)buf.length, (long)cachedFile.length());
                }
                catch (URISyntaxException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (blobServer != null) {
                blobServer.shutdown();
            }
            if (blobCache != null) {
                blobCache.shutdown();
            }
        }
    }
}

