/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Random;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.util.OperatingSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class BlobServerPutTest {
    private final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutBufferSuccessful() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key1 = client.put(data);
            Assert.assertNotNull((Object)key1);
            BlobKey key2 = client.put(data, 10, 44);
            Assert.assertNotNull((Object)key2);
            JobID jid = new JobID();
            String stringKey = "my test key";
            client.put(jid, stringKey, data);
            InputStream is1 = client.get(key2);
            byte[] result1 = new byte[44];
            BlobUtils.readFully((InputStream)is1, (byte[])result1, (int)0, (int)result1.length, null);
            is1.close();
            int i = 0;
            int j = 10;
            while (i < result1.length) {
                Assert.assertEquals((long)data[j], (long)result1[i]);
                ++i;
                ++j;
            }
            client.close();
            client = new BlobClient(serverAddress);
            InputStream is2 = client.get(key1);
            byte[] result2 = new byte[data.length];
            BlobUtils.readFully((InputStream)is2, (byte[])result2, (int)0, (int)result2.length, null);
            is2.close();
            Assert.assertArrayEquals((byte[])data, (byte[])result2);
            InputStream is3 = client.get(jid, stringKey);
            byte[] result3 = new byte[data.length];
            BlobUtils.readFully((InputStream)is3, (byte[])result3, (int)0, (int)result3.length, null);
            is3.close();
            Assert.assertArrayEquals((byte[])data, (byte[])result3);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutStreamSuccessful() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key1 = client.put((InputStream)new ByteArrayInputStream(data));
            Assert.assertNotNull((Object)key1);
            JobID jid = new JobID();
            String stringKey = "my test key";
            client.put(jid, stringKey, (InputStream)new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutChunkedStreamSuccessful() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key1 = client.put((InputStream)new ChunkedInputStream(data, 19));
            Assert.assertNotNull((Object)key1);
            JobID jid = new JobID();
            String stringKey = "my test key";
            client.put(jid, stringKey, (InputStream)new ChunkedInputStream(data, 17));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutBufferFails() {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        BlobServer server = null;
        BlobClient client = null;
        File tempFileDir = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            tempFileDir = server.createTemporaryFilename().getParentFile().getParentFile();
            Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            try {
                client.put(data);
                Assert.fail((String)"This should fail.");
            }
            catch (IOException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Server side error"));
            }
            try {
                client.put(data);
                Assert.fail((String)"Client should be closed");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (tempFileDir != null) {
                tempFileDir.setWritable(true, false);
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutNamedBufferFails() {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        BlobServer server = null;
        BlobClient client = null;
        File tempFileDir = null;
        try {
            String stringKey;
            JobID jid;
            Configuration config = new Configuration();
            server = new BlobServer(config);
            tempFileDir = server.createTemporaryFilename().getParentFile().getParentFile();
            Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            try {
                jid = new JobID();
                stringKey = "my test key";
                client.put(jid, stringKey, data);
                Assert.fail((String)"This should fail.");
            }
            catch (IOException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Server side error"));
            }
            try {
                jid = new JobID();
                stringKey = "another key";
                client.put(jid, stringKey, data);
                Assert.fail((String)"Client should be closed");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (tempFileDir != null) {
                tempFileDir.setWritable(true, false);
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    private static final class ChunkedInputStream
    extends InputStream {
        private final byte[][] data;
        private int x = 0;
        private int y = 0;

        private ChunkedInputStream(byte[] data, int numChunks) {
            this.data = new byte[numChunks][];
            int bytesPerChunk = data.length / numChunks;
            int bytesTaken = 0;
            int i = 0;
            while (i < numChunks - 1) {
                this.data[i] = new byte[bytesPerChunk];
                System.arraycopy(data, bytesTaken, this.data[i], 0, bytesPerChunk);
                ++i;
                bytesTaken += bytesPerChunk;
            }
            this.data[numChunks - 1] = new byte[data.length - bytesTaken];
            System.arraycopy(data, bytesTaken, this.data[numChunks - 1], 0, this.data[numChunks - 1].length);
        }

        @Override
        public int read() {
            if (this.x < this.data.length) {
                byte[] curr = this.data[this.x];
                if (this.y < curr.length) {
                    byte next = curr[this.y];
                    ++this.y;
                    return next;
                }
                this.y = 0;
                ++this.x;
                return this.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.x < this.data.length) {
                byte[] curr = this.data[this.x];
                if (this.y < curr.length) {
                    int toCopy = Math.min(len, curr.length - this.y);
                    System.arraycopy(curr, this.y, b, off, toCopy);
                    this.y += toCopy;
                    return toCopy;
                }
                this.y = 0;
                ++this.x;
                return this.read(b, off, len);
            }
            return -1;
        }
    }
}

