/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.runtime.checkpoint.StateStore;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractStateStoreTest {
    abstract StateStore<Integer> createStateStore() throws Exception;

    abstract boolean verifyDiscarded(StateStore<Integer> var1, String var2);

    @Test
    public void testSimplePutGetDiscardSequence() throws Exception {
        StateStore<Integer> stateStore = this.createStateStore();
        Integer expectedState = 211155;
        String path = stateStore.putState((Serializable)expectedState);
        Integer actualState = (Integer)stateStore.getState(path);
        Assert.assertEquals((Object)expectedState, (Object)actualState);
        stateStore.disposeState(path);
        Assert.assertTrue((boolean)this.verifyDiscarded(stateStore, path));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetStateInvalidPathThrowsException() throws Exception {
        StateStore<Integer> stateStore = this.createStateStore();
        stateStore.getState("testGetStateInvalidPathThrowsException");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisposeStateInvalidPathThrowsException() throws Exception {
        StateStore<Integer> stateStore = this.createStateStore();
        stateStore.getState("testDisposeStateInvalidPathThrowsException");
    }
}

