/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.lang.reflect.Field;
import java.net.InetAddress;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.BaseTestingActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.messages.Messages;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.concurrent.ExecutionContext;

public class ExecutionGraphTestUtils {
    public static final String ERROR_MESSAGE = "test_failure_error_message";

    public static void setVertexState(ExecutionVertex vertex, ExecutionState state) {
        try {
            Execution exec = vertex.getCurrentExecutionAttempt();
            Field f = Execution.class.getDeclaredField("state");
            f.setAccessible(true);
            f.set(exec, state);
        }
        catch (Exception e) {
            throw new RuntimeException("Modifying the state failed", e);
        }
    }

    public static void setVertexResource(ExecutionVertex vertex, SimpleSlot slot) {
        try {
            Execution exec = vertex.getCurrentExecutionAttempt();
            Field f = Execution.class.getDeclaredField("assignedResource");
            f.setAccessible(true);
            f.set(exec, slot);
        }
        catch (Exception e) {
            throw new RuntimeException("Modifying the slot failed", e);
        }
    }

    public static void setGraphStatus(ExecutionGraph graph, JobStatus status) {
        try {
            Field f = ExecutionGraph.class.getDeclaredField("state");
            f.setAccessible(true);
            f.set(graph, status);
        }
        catch (Exception e) {
            throw new RuntimeException("Modifying the status failed", e);
        }
    }

    public static Instance getInstance(ActorGateway gateway) throws Exception {
        return ExecutionGraphTestUtils.getInstance(gateway, 1);
    }

    public static Instance getInstance(ActorGateway gateway, int numberOfSlots) throws Exception {
        HardwareDescription hardwareDescription = new HardwareDescription(4, 0x80000000L, 0x40000000L, 0x20000000L);
        InetAddress address = InetAddress.getByName("127.0.0.1");
        InstanceConnectionInfo connection = new InstanceConnectionInfo(address, 10001);
        return new Instance(gateway, connection, new InstanceID(), hardwareDescription, numberOfSlots);
    }

    public static ExecutionJobVertex getExecutionVertex(JobVertexID id, ExecutionContext executionContext) throws JobException {
        JobVertex ajv = new JobVertex("TestVertex", id);
        ajv.setInvokableClass(((AbstractInvokable)Mockito.mock(AbstractInvokable.class)).getClass());
        ExecutionGraph graph = new ExecutionGraph(executionContext, new JobID(), "test job", new Configuration(), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy());
        ExecutionJobVertex ejv = (ExecutionJobVertex)Mockito.spy((Object)new ExecutionJobVertex(graph, ajv, 1, AkkaUtils.getDefaultTimeout()));
        Answer<Void> noop = new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                return null;
            }
        };
        ((ExecutionJobVertex)Mockito.doAnswer((Answer)noop).when((Object)ejv)).vertexCancelled(Matchers.anyInt());
        ((ExecutionJobVertex)Mockito.doAnswer((Answer)noop).when((Object)ejv)).vertexFailed(Matchers.anyInt(), (Throwable)Matchers.any(Throwable.class));
        ((ExecutionJobVertex)Mockito.doAnswer((Answer)noop).when((Object)ejv)).vertexFinished(Matchers.anyInt());
        return ejv;
    }

    public static ExecutionJobVertex getExecutionVertex(JobVertexID id) throws JobException {
        return ExecutionGraphTestUtils.getExecutionVertex(id, (ExecutionContext)TestingUtils.defaultExecutionContext());
    }

    public static class SimpleFailingActorGateway
    extends BaseTestingActorGateway {
        public SimpleFailingActorGateway(ExecutionContext executionContext) {
            super(executionContext);
        }

        @Override
        public Object handleMessage(Object message) throws Exception {
            if (message instanceof TaskMessages.SubmitTask) {
                throw new Exception(ExecutionGraphTestUtils.ERROR_MESSAGE);
            }
            if (message instanceof TaskMessages.CancelTask) {
                TaskMessages.CancelTask cancelTask = (TaskMessages.CancelTask)message;
                return new TaskMessages.TaskOperationResult(cancelTask.attemptID(), true);
            }
            return null;
        }
    }

    public static class SimpleActorGateway
    extends BaseTestingActorGateway {
        public TaskDeploymentDescriptor lastTDD;

        public SimpleActorGateway(ExecutionContext executionContext) {
            super(executionContext);
        }

        @Override
        public Object handleMessage(Object message) {
            Object result = null;
            if (message instanceof TaskMessages.SubmitTask) {
                TaskMessages.SubmitTask submitTask = (TaskMessages.SubmitTask)message;
                this.lastTDD = submitTask.tasks();
                result = Messages.getAcknowledge();
            } else if (message instanceof TaskMessages.CancelTask) {
                TaskMessages.CancelTask cancelTask = (TaskMessages.CancelTask)message;
                result = new TaskMessages.TaskOperationResult(cancelTask.attemptID(), true);
            } else if (message instanceof TaskMessages.FailIntermediateResultPartitions) {
                result = new Object();
            }
            return result;
        }
    }
}

