/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.lang.reflect.Method;
import java.net.InetAddress;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.junit.Assert;
import org.junit.Test;

public class InstanceTest {
    @Test
    public void testAllocatingAndCancellingSlots() {
        try {
            HardwareDescription hardwareDescription = new HardwareDescription(4, 0x80000000L, 0x40000000L, 0x20000000L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            InstanceConnectionInfo connection = new InstanceConnectionInfo(address, 10001);
            Instance instance = new Instance((ActorGateway)DummyActorGateway.INSTANCE, connection, new InstanceID(), hardwareDescription, 4);
            Assert.assertEquals((long)4L, (long)instance.getTotalNumberOfSlots());
            Assert.assertEquals((long)4L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
            SimpleSlot slot1 = instance.allocateSimpleSlot(new JobID());
            SimpleSlot slot2 = instance.allocateSimpleSlot(new JobID());
            SimpleSlot slot3 = instance.allocateSimpleSlot(new JobID());
            SimpleSlot slot4 = instance.allocateSimpleSlot(new JobID());
            Assert.assertNotNull((Object)slot1);
            Assert.assertNotNull((Object)slot2);
            Assert.assertNotNull((Object)slot3);
            Assert.assertNotNull((Object)slot4);
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)4L, (long)instance.getNumberOfAllocatedSlots());
            Assert.assertEquals((long)6L, (long)(slot1.getSlotNumber() + slot2.getSlotNumber() + slot3.getSlotNumber() + slot4.getSlotNumber()));
            Assert.assertNull((Object)instance.allocateSimpleSlot(new JobID()));
            try {
                instance.returnAllocatedSlot((Slot)slot2);
                Assert.fail((String)"instance accepted a non-cancelled slot.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            slot1.releaseSlot();
            slot2.releaseSlot();
            slot3.releaseSlot();
            slot4.releaseSlot();
            Assert.assertEquals((long)4L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
            Assert.assertFalse((boolean)instance.returnAllocatedSlot((Slot)slot1));
            Assert.assertFalse((boolean)instance.returnAllocatedSlot((Slot)slot2));
            Assert.assertFalse((boolean)instance.returnAllocatedSlot((Slot)slot3));
            Assert.assertFalse((boolean)instance.returnAllocatedSlot((Slot)slot4));
            Assert.assertEquals((long)4L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInstanceDies() {
        try {
            HardwareDescription hardwareDescription = new HardwareDescription(4, 0x80000000L, 0x40000000L, 0x20000000L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            InstanceConnectionInfo connection = new InstanceConnectionInfo(address, 10001);
            Instance instance = new Instance((ActorGateway)DummyActorGateway.INSTANCE, connection, new InstanceID(), hardwareDescription, 3);
            Assert.assertEquals((long)3L, (long)instance.getNumberOfAvailableSlots());
            SimpleSlot slot1 = instance.allocateSimpleSlot(new JobID());
            SimpleSlot slot2 = instance.allocateSimpleSlot(new JobID());
            SimpleSlot slot3 = instance.allocateSimpleSlot(new JobID());
            instance.markDead();
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertTrue((boolean)slot1.isCanceled());
            Assert.assertTrue((boolean)slot2.isCanceled());
            Assert.assertTrue((boolean)slot3.isCanceled());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelAllSlots() {
        try {
            HardwareDescription hardwareDescription = new HardwareDescription(4, 0x80000000L, 0x40000000L, 0x20000000L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            InstanceConnectionInfo connection = new InstanceConnectionInfo(address, 10001);
            Instance instance = new Instance((ActorGateway)DummyActorGateway.INSTANCE, connection, new InstanceID(), hardwareDescription, 3);
            Assert.assertEquals((long)3L, (long)instance.getNumberOfAvailableSlots());
            SimpleSlot slot1 = instance.allocateSimpleSlot(new JobID());
            SimpleSlot slot2 = instance.allocateSimpleSlot(new JobID());
            SimpleSlot slot3 = instance.allocateSimpleSlot(new JobID());
            instance.cancelAndReleaseAllSlots();
            Assert.assertEquals((long)3L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertTrue((boolean)slot1.isCanceled());
            Assert.assertTrue((boolean)slot2.isCanceled());
            Assert.assertTrue((boolean)slot3.isCanceled());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInstancesReferenceEqual() {
        try {
            Method m = Instance.class.getMethod("equals", Object.class);
            Assert.assertTrue((m.getDeclaringClass() == Object.class ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

