/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization.types;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestTypeFactory;

public final class Util {
    private static final long SEED = 64871654635745873L;
    private static Random random = new Random(64871654635745873L);

    public static SerializationTestType randomRecord(SerializationTestTypeFactory type) {
        return type.factory().getRandom(random);
    }

    public static MockRecords randomRecords(int numElements, final SerializationTestTypeFactory type) {
        return new MockRecords(numElements){

            @Override
            protected SerializationTestType getRecord() {
                return type.factory().getRandom(random);
            }
        };
    }

    public static MockRecords randomRecords(int numElements) {
        return new MockRecords(numElements){

            @Override
            protected SerializationTestType getRecord() {
                SerializationTestTypeFactory[] types = SerializationTestTypeFactory.values();
                int i = random.nextInt(types.length);
                return types[i].factory().getRandom(random);
            }
        };
    }

    private Util() {
        throw new RuntimeException();
    }

    public static abstract class MockRecords
    implements Iterable<SerializationTestType> {
        private int numRecords;

        public MockRecords(int numRecords) {
            this.numRecords = numRecords;
        }

        @Override
        public Iterator<SerializationTestType> iterator() {
            return new Iterator<SerializationTestType>(){

                @Override
                public boolean hasNext() {
                    return MockRecords.this.numRecords > 0;
                }

                @Override
                public SerializationTestType next() {
                    if (MockRecords.this.numRecords > 0) {
                        MockRecords.this.numRecords--;
                        return MockRecords.this.getRecord();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected abstract SerializationTestType getRecord();
    }
}

