/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PartitionRequestQueueTest {
    @Test
    public void testProducerFailedException() throws Exception {
        PartitionRequestQueue queue = new PartitionRequestQueue();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{queue});
        ResultSubpartitionView view = (ResultSubpartitionView)Mockito.mock(ResultSubpartitionView.class);
        Mockito.when((Object)view.isReleased()).thenReturn((Object)true);
        Mockito.when((Object)view.getFailureCause()).thenReturn((Object)new RuntimeException("Expected test exception"));
        queue.enqueue(view, new InputChannelID());
        ch.runPendingTasks();
        Object msg = ch.readOutbound();
        Assert.assertEquals(msg.getClass(), NettyMessage.ErrorResponse.class);
        NettyMessage.ErrorResponse err = (NettyMessage.ErrorResponse)msg;
        Assert.assertTrue((boolean)(err.cause instanceof CancelTaskException));
    }
}

