/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.LocalConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.netty.PartitionStateChecker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.UnknownInputChannel;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Tuple2;

public class SingleInputGateTest {
    @Test(timeout=120000L)
    public void testBasicGetNextLogic() throws Exception {
        SingleInputGate inputGate = new SingleInputGate("Test Task Name", new JobID(), new ExecutionAttemptID(), new IntermediateDataSetID(), 0, 2, (PartitionStateChecker)Mockito.mock(PartitionStateChecker.class));
        TestInputChannel[] inputChannels = new TestInputChannel[]{new TestInputChannel(inputGate, 0), new TestInputChannel(inputGate, 1)};
        inputGate.setInputChannel(new IntermediateResultPartitionID(), inputChannels[0].getInputChannel());
        inputGate.setInputChannel(new IntermediateResultPartitionID(), inputChannels[1].getInputChannel());
        inputChannels[0].readBuffer();
        inputChannels[0].readBuffer();
        inputChannels[1].readBuffer();
        inputChannels[1].readEndOfPartitionEvent();
        inputChannels[0].readEndOfPartitionEvent();
        SingleInputGateTest.verifyBufferOrEvent((InputGate)inputGate, true, 0);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)inputGate, true, 0);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)inputGate, true, 1);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)inputGate, false, 1);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)inputGate, false, 0);
        Assert.assertTrue((boolean)inputGate.isFinished());
        Assert.assertNull((Object)inputGate.getNextBufferOrEvent());
    }

    @Test
    public void testBackwardsEventWithUninitializedChannel() throws Exception {
        TaskEventDispatcher taskEventDispatcher = (TaskEventDispatcher)Mockito.mock(TaskEventDispatcher.class);
        Mockito.when((Object)taskEventDispatcher.publish((ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskEvent)Matchers.any(TaskEvent.class))).thenReturn((Object)true);
        ResultSubpartitionView iterator = (ResultSubpartitionView)Mockito.mock(ResultSubpartitionView.class);
        Mockito.when((Object)iterator.getNextBuffer()).thenReturn((Object)new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)1024), (BufferRecycler)Mockito.mock(BufferRecycler.class)));
        ResultPartitionManager partitionManager = (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class);
        Mockito.when((Object)partitionManager.createSubpartitionView((ResultPartitionID)Matchers.any(ResultPartitionID.class), Matchers.anyInt(), (BufferProvider)Matchers.any(BufferProvider.class))).thenReturn((Object)iterator);
        IntermediateDataSetID resultId = new IntermediateDataSetID();
        SingleInputGate inputGate = new SingleInputGate("Test Task Name", new JobID(), new ExecutionAttemptID(), resultId, 0, 2, (PartitionStateChecker)Mockito.mock(PartitionStateChecker.class));
        BufferPool bufferPool = (BufferPool)Mockito.mock(BufferPool.class);
        Mockito.when((Object)bufferPool.getNumberOfRequiredMemorySegments()).thenReturn((Object)2);
        inputGate.setBufferPool(bufferPool);
        ResultPartitionID localPartitionId = new ResultPartitionID(new IntermediateResultPartitionID(), new ExecutionAttemptID());
        LocalInputChannel local = new LocalInputChannel(inputGate, 0, localPartitionId, partitionManager, taskEventDispatcher);
        ResultPartitionID unknownPartitionId = new ResultPartitionID(new IntermediateResultPartitionID(), new ExecutionAttemptID());
        UnknownInputChannel unknown = new UnknownInputChannel(inputGate, 1, unknownPartitionId, partitionManager, taskEventDispatcher, (ConnectionManager)Mockito.mock(ConnectionManager.class), new Tuple2((Object)0, (Object)0));
        inputGate.setInputChannel(localPartitionId.getPartitionId(), (InputChannel)local);
        inputGate.setInputChannel(unknownPartitionId.getPartitionId(), (InputChannel)unknown);
        inputGate.requestPartitions();
        ((ResultPartitionManager)Mockito.verify((Object)partitionManager, (VerificationMode)Mockito.times((int)1))).createSubpartitionView((ResultPartitionID)Matchers.any(ResultPartitionID.class), Matchers.anyInt(), (BufferProvider)Matchers.any(BufferProvider.class));
        TestTaskEvent event = new TestTaskEvent();
        inputGate.sendTaskEvent((TaskEvent)event);
        ((TaskEventDispatcher)Mockito.verify((Object)taskEventDispatcher, (VerificationMode)Mockito.times((int)1))).publish((ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskEvent)Matchers.any(TaskEvent.class));
        inputGate.updateInputChannel(new InputChannelDeploymentDescriptor(new ResultPartitionID(unknownPartitionId.getPartitionId(), unknownPartitionId.getProducerId()), ResultPartitionLocation.createLocal()));
        ((ResultPartitionManager)Mockito.verify((Object)partitionManager, (VerificationMode)Mockito.times((int)2))).createSubpartitionView((ResultPartitionID)Matchers.any(ResultPartitionID.class), Matchers.anyInt(), (BufferProvider)Matchers.any(BufferProvider.class));
        ((TaskEventDispatcher)Mockito.verify((Object)taskEventDispatcher, (VerificationMode)Mockito.times((int)2))).publish((ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskEvent)Matchers.any(TaskEvent.class));
    }

    @Test
    public void testUpdateChannelBeforeRequest() throws Exception {
        SingleInputGate inputGate = new SingleInputGate("t1", new JobID(), new ExecutionAttemptID(), new IntermediateDataSetID(), 0, 1, (PartitionStateChecker)Mockito.mock(PartitionStateChecker.class));
        ResultPartitionManager partitionManager = (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class);
        UnknownInputChannel unknown = new UnknownInputChannel(inputGate, 0, new ResultPartitionID(), partitionManager, new TaskEventDispatcher(), (ConnectionManager)new LocalConnectionManager(), new Tuple2((Object)0, (Object)0));
        inputGate.setInputChannel(unknown.partitionId.getPartitionId(), (InputChannel)unknown);
        inputGate.updateInputChannel(new InputChannelDeploymentDescriptor(unknown.partitionId, ResultPartitionLocation.createLocal()));
        ((ResultPartitionManager)Mockito.verify((Object)partitionManager, (VerificationMode)Mockito.never())).createSubpartitionView((ResultPartitionID)Matchers.any(ResultPartitionID.class), Matchers.anyInt(), (BufferProvider)Matchers.any(BufferProvider.class));
    }

    static void verifyBufferOrEvent(InputGate inputGate, boolean isBuffer, int channelIndex) throws IOException, InterruptedException {
        BufferOrEvent boe = inputGate.getNextBufferOrEvent();
        Assert.assertEquals((Object)isBuffer, (Object)boe.isBuffer());
        Assert.assertEquals((long)channelIndex, (long)boe.getChannelIndex());
    }
}

