/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAllocationFuture;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAllocationFutureAction;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.ExecutionContext;

public class SchedulerIsolatedTasksTest {
    @Test
    public void testAddAndRemoveInstance() {
        try {
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(2);
            Instance i2 = SchedulerTestUtils.getRandomInstance(2);
            Instance i3 = SchedulerTestUtils.getRandomInstance(2);
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            scheduler.newInstanceAvailable(i1);
            Assert.assertEquals((long)1L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            scheduler.newInstanceAvailable(i2);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
            scheduler.newInstanceAvailable(i3);
            Assert.assertEquals((long)3L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)6L, (long)scheduler.getNumberOfAvailableSlots());
            try {
                scheduler.newInstanceAvailable(i2);
                Assert.fail((String)"Scheduler accepted instance twice");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Assert.assertEquals((long)3L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)6L, (long)scheduler.getNumberOfAvailableSlots());
            scheduler.instanceDied(i2);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
            try {
                scheduler.newInstanceAvailable(i2);
                Assert.fail((String)"Scheduler accepted dead instance");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            scheduler.instanceDied(i1);
            Assert.assertEquals((long)1L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            scheduler.instanceDied(i3);
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableInstances());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertFalse((boolean)i1.isAlive());
            Assert.assertFalse((boolean)i2.isAlive());
            Assert.assertFalse((boolean)i3.isAlive());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleImmediately() {
        try {
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(1));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            Assert.assertEquals((long)5L, (long)scheduler.getNumberOfAvailableSlots());
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
            SimpleSlot s5 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1, s2, s3, s4, s5));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
                Assert.fail((String)"Scheduler accepted scheduling request without available resource.");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
                // empty catch block
            }
            s3.releaseSlot();
            s4.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SimpleSlot s6 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
            SimpleSlot s7 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1, s2, s3, s4, s5, s6, s7));
            s1.releaseSlot();
            s2.releaseSlot();
            s5.releaseSlot();
            s6.releaseSlot();
            s7.releaseSlot();
            Assert.assertEquals((long)5L, (long)scheduler.getNumberOfAvailableSlots());
            s1.releaseSlot();
            s2.releaseSlot();
            s5.releaseSlot();
            s6.releaseSlot();
            s7.releaseSlot();
            Assert.assertEquals((long)5L, (long)scheduler.getNumberOfAvailableSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleQueueing() {
        int NUM_INSTANCES = 50;
        int NUM_SLOTS_PER_INSTANCE = 3;
        int NUM_TASKS_TO_SCHEDULE = 2000;
        try {
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            for (int i = 0; i < 50; ++i) {
                scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance((int)(Math.random() * 3.0) + 1));
            }
            Assert.assertEquals((long)50L, (long)scheduler.getNumberOfAvailableInstances());
            int totalSlots = scheduler.getNumberOfAvailableSlots();
            ArrayList<SlotAllocationFuture> allAllocatedSlots = new ArrayList<SlotAllocationFuture>();
            final HashSet toRelease = new HashSet();
            final AtomicBoolean errored = new AtomicBoolean(false);
            SlotAllocationFutureAction action = new SlotAllocationFutureAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void slotAllocated(SimpleSlot slot) {
                    Set set = toRelease;
                    synchronized (set) {
                        toRelease.add(slot);
                        toRelease.notifyAll();
                    }
                }
            };
            Runnable disposer = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        for (int recycled = 0; recycled < 2000; ++recycled) {
                            Set set = toRelease;
                            synchronized (set) {
                                while (toRelease.isEmpty()) {
                                    toRelease.wait();
                                }
                                Iterator iter = toRelease.iterator();
                                SimpleSlot next = (SimpleSlot)iter.next();
                                iter.remove();
                                next.releaseSlot();
                                continue;
                            }
                        }
                        return;
                    }
                    catch (Throwable t) {
                        errored.set(true);
                    }
                }
            };
            Thread disposeThread = new Thread(disposer);
            disposeThread.start();
            for (int i = 0; i < 2000; ++i) {
                SlotAllocationFuture future = scheduler.scheduleQueued(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
                future.setFutureAction(action);
                allAllocatedSlots.add(future);
            }
            disposeThread.join();
            Assert.assertFalse((String)"The slot releasing thread caused an error.", (boolean)errored.get());
            ArrayList<SimpleSlot> slotsAfter = new ArrayList<SimpleSlot>();
            for (SlotAllocationFuture future : allAllocatedSlots) {
                slotsAfter.add(future.waitTillAllocated());
            }
            Assert.assertEquals((String)"All instances should have available slots.", (long)50L, (long)scheduler.getNumberOfInstancesWithAvailableSlots());
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(slotsAfter.toArray()));
            Assert.assertEquals((String)"All slots should be available.", (long)totalSlots, (long)scheduler.getNumberOfAvailableSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleWithDyingInstances() {
        try {
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(2);
            Instance i2 = SchedulerTestUtils.getRandomInstance(2);
            Instance i3 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            scheduler.newInstanceAvailable(i3);
            ArrayList<SimpleSlot> slots = new ArrayList<SimpleSlot>();
            slots.add(scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask())));
            slots.add(scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask())));
            slots.add(scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask())));
            slots.add(scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask())));
            slots.add(scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask())));
            i2.markDead();
            for (SimpleSlot slot : slots) {
                if (slot.getInstance() == i2) {
                    Assert.assertTrue((boolean)slot.isCanceled());
                } else {
                    Assert.assertFalse((boolean)slot.isCanceled());
                }
                slot.releaseSlot();
            }
            Assert.assertEquals((long)3L, (long)scheduler.getNumberOfAvailableSlots());
            i1.markDead();
            i3.markDead();
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getDummyTask()));
                Assert.fail((String)"Scheduler served a slot from a dead instance");
            }
            catch (NoResourceAvailableException i$) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception type.");
            }
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfInstancesWithAvailableSlots());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSchedulingLocation() {
        try {
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(2);
            Instance i2 = SchedulerTestUtils.getRandomInstance(2);
            Instance i3 = SchedulerTestUtils.getRandomInstance(2);
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            scheduler.newInstanceAvailable(i3);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(Collections.emptyList())));
            Instance first = s1.getInstance();
            Instance second = first != i1 ? i1 : i2;
            Instance third = first == i3 ? i2 : i3;
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(Collections.singletonList(s1.getInstance()))));
            Assert.assertEquals((Object)first, (Object)s2.getInstance());
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(Arrays.asList(first, second))));
            Assert.assertEquals((Object)second, (Object)s3.getInstance());
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(Arrays.asList(first, third))));
            SimpleSlot s5 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(Arrays.asList(first, third))));
            Assert.assertEquals((Object)third, (Object)s4.getInstance());
            Assert.assertEquals((Object)third, (Object)s5.getInstance());
            SimpleSlot s6 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(Arrays.asList(first, third))));
            Assert.assertEquals((Object)second, (Object)s6.getInstance());
            s2.releaseSlot();
            s6.releaseSlot();
            SimpleSlot s7 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(Arrays.asList(first, third))));
            Assert.assertEquals((Object)first, (Object)s7.getInstance());
            Assert.assertEquals((long)1L, (long)scheduler.getNumberOfUnconstrainedAssignments());
            Assert.assertEquals((long)1L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)5L, (long)scheduler.getNumberOfLocalizedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

