/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAllocationFuture;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAllocationFutureAction;
import org.junit.Assert;
import org.junit.Test;

public class SlotAllocationFutureTest {
    @Test
    public void testInvalidActions() {
        try {
            SlotAllocationFuture future = new SlotAllocationFuture();
            SlotAllocationFutureAction action = new SlotAllocationFutureAction(){

                public void slotAllocated(SimpleSlot slot) {
                }
            };
            future.setFutureAction(action);
            try {
                future.setFutureAction(action);
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            SimpleSlot slot1 = new SimpleSlot(new JobID(), SchedulerTestUtils.getRandomInstance(1), 0, null, null);
            SimpleSlot slot2 = new SimpleSlot(new JobID(), SchedulerTestUtils.getRandomInstance(1), 0, null, null);
            future.setSlot(slot1);
            try {
                future.setSlot(slot2);
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void setWithAction() {
        try {
            final AtomicInteger invocations = new AtomicInteger();
            final SimpleSlot thisSlot = new SimpleSlot(new JobID(), SchedulerTestUtils.getRandomInstance(1), 0, null, null);
            SlotAllocationFuture future = new SlotAllocationFuture();
            future.setFutureAction(new SlotAllocationFutureAction(){

                public void slotAllocated(SimpleSlot slot) {
                    Assert.assertEquals((Object)thisSlot, (Object)slot);
                    invocations.incrementAndGet();
                }
            });
            future.setSlot(thisSlot);
            Assert.assertEquals((long)1L, (long)invocations.get());
            invocations = new AtomicInteger();
            thisSlot = new SimpleSlot(new JobID(), SchedulerTestUtils.getRandomInstance(1), 0, null, null);
            future = new SlotAllocationFuture();
            future.setSlot(thisSlot);
            future.setFutureAction(new SlotAllocationFutureAction(){

                public void slotAllocated(SimpleSlot slot) {
                    Assert.assertEquals((Object)thisSlot, (Object)slot);
                    invocations.incrementAndGet();
                }
            });
            Assert.assertEquals((long)1L, (long)invocations.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void setSync() {
        try {
            final AtomicInteger invocations = new AtomicInteger();
            final AtomicBoolean error = new AtomicBoolean();
            final SimpleSlot thisSlot = new SimpleSlot(new JobID(), SchedulerTestUtils.getRandomInstance(1), 0, null, null);
            final SlotAllocationFuture future = new SlotAllocationFuture();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        SimpleSlot syncSlot = future.waitTillAllocated();
                        if (syncSlot == null || syncSlot != thisSlot) {
                            error.set(true);
                            return;
                        }
                        invocations.incrementAndGet();
                    }
                    catch (Throwable t) {
                        error.set(true);
                    }
                }
            };
            Thread syncer = new Thread(r);
            syncer.start();
            Thread.sleep(10L);
            future.setSlot(thisSlot);
            syncer.join();
            Assert.assertFalse((boolean)error.get());
            Assert.assertEquals((long)1L, (long)invocations.get());
            SimpleSlot thisSlot2 = new SimpleSlot(new JobID(), SchedulerTestUtils.getRandomInstance(1), 0, null, null);
            SlotAllocationFuture future2 = new SlotAllocationFuture();
            future2.setSlot(thisSlot2);
            SimpleSlot retrieved = future2.waitTillAllocated();
            Assert.assertNotNull((Object)retrieved);
            Assert.assertEquals((Object)thisSlot2, (Object)retrieved);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

