/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.util.BitSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitSetTest {
    private BitSet bitSet;
    int byteSize = 1024;
    MemorySegment memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)this.byteSize);

    @Before
    public void init() {
        this.bitSet = new BitSet(this.byteSize);
        this.bitSet.setMemorySegment(this.memorySegment, 0);
        this.bitSet.clear();
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyBitSetSize1() {
        this.bitSet.setMemorySegment(this.memorySegment, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyBitSetSize2() {
        this.bitSet.setMemorySegment(null, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyBitSetSize3() {
        this.bitSet.setMemorySegment(this.memorySegment, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyInputIndex1() {
        this.bitSet.set(8 * this.byteSize + 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyInputIndex2() {
        this.bitSet.set(-1);
    }

    @Test
    public void testSetValues() {
        int i;
        int bitSize = this.bitSet.bitSize();
        Assert.assertEquals((long)bitSize, (long)8192L);
        for (i = 0; i < bitSize; ++i) {
            Assert.assertFalse((boolean)this.bitSet.get(i));
            if (i % 2 != 0) continue;
            this.bitSet.set(i);
        }
        for (i = 0; i < bitSize; ++i) {
            if (i % 2 == 0) {
                Assert.assertTrue((boolean)this.bitSet.get(i));
                continue;
            }
            Assert.assertFalse((boolean)this.bitSet.get(i));
        }
    }
}

