/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.filesystem.FileStreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class FileStateBackendTest
extends StateBackendTestBase<FsStateBackend> {
    private File stateDir;

    @Override
    protected FsStateBackend getStateBackend() throws Exception {
        this.stateDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        return new FsStateBackend(FileStateBackendTest.localFileUri(this.stateDir));
    }

    @Override
    protected void cleanup() throws Exception {
        FileStateBackendTest.deleteDirectorySilently(this.stateDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetupAndSerialization() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            String backendDir = FileStateBackendTest.localFileUri(tempDir);
            FsStateBackend originalBackend = new FsStateBackend(backendDir);
            Assert.assertFalse((boolean)originalBackend.isInitialized());
            Assert.assertEquals((Object)new URI(backendDir), (Object)originalBackend.getBasePath().toUri());
            Assert.assertNull((Object)originalBackend.getCheckpointDirectory());
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)originalBackend);
            Assert.assertFalse((boolean)backend.isInitialized());
            Assert.assertEquals((Object)new URI(backendDir), (Object)backend.getBasePath().toUri());
            Assert.assertNull((Object)backend.getCheckpointDirectory());
            try {
                backend.checkpointStateSerializable((Serializable)((Object)"exception train rolling in"), 2L, System.currentTimeMillis());
                Assert.fail((String)"should fail with an exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            backend.initializeForJob((Environment)new DummyEnvironment("test", 1, 0), "test-op", (TypeSerializer)IntSerializer.INSTANCE);
            Assert.assertNotNull((Object)backend.getCheckpointDirectory());
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            Assert.assertTrue((boolean)checkpointDir.exists());
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            backend.disposeAllStateForCurrentJob();
            Assert.assertNull((Object)backend.getCheckpointDirectory());
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(tempDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializableState() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(FileStateBackendTest.localFileUri(tempDir)));
            backend.initializeForJob((Environment)new DummyEnvironment("test", 1, 0), "test-op", (TypeSerializer)IntSerializer.INSTANCE);
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            String state1 = "dummy state";
            String state2 = "row row row your boat";
            Integer state3 = 42;
            StateHandle handle1 = backend.checkpointStateSerializable((Serializable)((Object)state1), 439568923746L, System.currentTimeMillis());
            StateHandle handle2 = backend.checkpointStateSerializable((Serializable)((Object)state2), 439568923746L, System.currentTimeMillis());
            StateHandle handle3 = backend.checkpointStateSerializable((Serializable)state3, 439568923746L, System.currentTimeMillis());
            Assert.assertEquals((Object)state1, (Object)handle1.getState(this.getClass().getClassLoader()));
            handle1.discardState();
            Assert.assertEquals((Object)state2, (Object)handle2.getState(this.getClass().getClassLoader()));
            handle2.discardState();
            Assert.assertEquals((Object)state3, (Object)handle3.getState(this.getClass().getClassLoader()));
            handle3.discardState();
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStateOutputStream() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            FileStreamStateHandle handle4;
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(tempDir.toURI(), 15));
            backend.initializeForJob((Environment)new DummyEnvironment("test", 1, 0), "test-op", (TypeSerializer)IntSerializer.INSTANCE);
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            byte[] state1 = new byte[0x137331];
            byte[] state2 = new byte[1];
            byte[] state3 = new byte[]{};
            byte[] state4 = new byte[177];
            Random rnd = new Random();
            rnd.nextBytes(state1);
            rnd.nextBytes(state2);
            rnd.nextBytes(state3);
            rnd.nextBytes(state4);
            long checkpointId = 97231523452L;
            FsStateBackend.FsCheckpointStateOutputStream stream1 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            FsStateBackend.FsCheckpointStateOutputStream stream2 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            FsStateBackend.FsCheckpointStateOutputStream stream3 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            stream1.write(state1);
            stream2.write(state2);
            stream3.write(state3);
            FileStreamStateHandle handle1 = (FileStreamStateHandle)stream1.closeAndGetHandle();
            ByteStreamStateHandle handle2 = (ByteStreamStateHandle)stream2.closeAndGetHandle();
            ByteStreamStateHandle handle3 = (ByteStreamStateHandle)stream3.closeAndGetHandle();
            try (FsStateBackend.FsCheckpointStateOutputStream stream4 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());){
                stream4.write(state4);
                handle4 = (FileStreamStateHandle)stream4.closeAndGetHandle();
            }
            FsStateBackend.FsCheckpointStateOutputStream stream5 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            stream5.write(state4);
            stream5.close();
            try {
                stream5.closeAndGetHandle();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileStateBackendTest.validateBytesInStream(handle1.getState(this.getClass().getClassLoader()), state1);
            handle1.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            FileStateBackendTest.ensureLocalFileDeleted(handle1.getFilePath());
            FileStateBackendTest.validateBytesInStream(handle2.getState(this.getClass().getClassLoader()), state2);
            handle2.discardState();
            FileStateBackendTest.validateBytesInStream(handle3.getState(this.getClass().getClassLoader()), state3);
            handle3.discardState();
            FileStateBackendTest.validateBytesInStream(handle4.getState(this.getClass().getClassLoader()), state4);
            handle4.discardState();
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    private static void ensureLocalFileDeleted(Path path) {
        URI uri = path.toUri();
        if (!"file".equals(uri.getScheme())) {
            throw new IllegalArgumentException("not a local path");
        }
        File file = new File(uri.getPath());
        Assert.assertFalse((String)"file not properly deleted", (boolean)file.exists());
    }

    private static void deleteDirectorySilently(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isDirectoryEmpty(File directory) {
        if (!directory.exists()) {
            return true;
        }
        String[] nested = directory.list();
        return nested == null || nested.length == 0;
    }

    private static String localFileUri(File path) {
        return path.toURI().toString();
    }

    private static void validateBytesInStream(InputStream is, byte[] data) throws IOException {
        int pos;
        int read;
        byte[] holder = new byte[data.length];
        for (pos = 0; pos < holder.length && (read = is.read(holder, pos, holder.length - pos)) != -1; pos += read) {
        }
        Assert.assertEquals((String)"not enough data", (long)holder.length, (long)pos);
        Assert.assertEquals((String)"too much data", (long)-1L, (long)is.read());
        Assert.assertArrayEquals((String)"wrong data", (byte[])data, (byte[])holder);
        is.close();
    }
}

