/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestJvmProcess {
    private static final Logger LOG = LoggerFactory.getLogger(TestJvmProcess.class);
    private final Object createDestroyLock = new Object();
    private final String javaCommandPath;
    private final String log4jConfigFilePath;
    private final Thread shutdownHook;
    private int jvmMemoryInMb = 80;
    private Process process;
    private volatile StringWriter processOutput;

    public TestJvmProcess() throws Exception {
        this(CommonTestUtils.getJavaCommandPath(), CommonTestUtils.createTemporaryLog4JProperties().getPath());
    }

    public TestJvmProcess(String javaCommandPath, String log4jConfigFilePath) {
        this.javaCommandPath = (String)Preconditions.checkNotNull((Object)javaCommandPath, (Object)"Java command path");
        this.log4jConfigFilePath = (String)Preconditions.checkNotNull((Object)log4jConfigFilePath, (Object)"log4j config file path");
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestJvmProcess.this.destroy();
                }
                catch (Throwable t) {
                    LOG.error("Error during process cleanup shutdown hook.", t);
                }
            }
        });
    }

    public abstract String getName();

    public abstract String[] getJvmArgs();

    public abstract String getEntryPointClassName();

    public void setJVMMemory(int jvmMemoryInMb) {
        Preconditions.checkArgument((jvmMemoryInMb >= 80 ? 1 : 0) != 0, (Object)"JobManager JVM Requires at least 80 MBs of memory.");
        this.jvmMemoryInMb = jvmMemoryInMb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws IOException {
        Object[] cmd = new String[]{this.javaCommandPath, "-Dlog.level=DEBUG", "-Dlog4j.configuration=file:" + this.log4jConfigFilePath, "-Xms" + this.jvmMemoryInMb + "m", "-Xmx" + this.jvmMemoryInMb + "m", "-classpath", CommonTestUtils.getCurrentClasspath(), this.getEntryPointClassName()};
        Object[] jvmArgs = this.getJvmArgs();
        if (jvmArgs != null && jvmArgs.length > 0) {
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])jvmArgs);
        }
        Object object = this.createDestroyLock;
        synchronized (object) {
            if (this.process == null) {
                LOG.debug("Running command '{}'.", (Object)Arrays.toString(cmd));
                this.process = new ProcessBuilder((String[])cmd).start();
                this.processOutput = new StringWriter();
                new CommonTestUtils.PipeForwarder(this.process.getErrorStream(), this.processOutput);
                try {
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Throwable t) {
                    LOG.error("Cannot register process cleanup shutdown hook.", t);
                }
            } else {
                throw new IllegalStateException("Already running.");
            }
        }
    }

    public void printProcessLog() {
        if (this.processOutput == null) {
            throw new IllegalStateException("Not started");
        }
        System.out.println("-----------------------------------------");
        System.out.println(" BEGIN SPAWNED PROCESS LOG FOR " + this.getName());
        System.out.println("-----------------------------------------");
        String out = this.processOutput.toString();
        if (out == null || out.length() == 0) {
            System.out.println("(EMPTY)");
        } else {
            System.out.println(out);
        }
        System.out.println("-----------------------------------------");
        System.out.println("\t\tEND SPAWNED PROCESS LOG " + this.getName());
        System.out.println("-----------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.createDestroyLock;
        synchronized (object) {
            if (this.process != null) {
                LOG.debug("Destroying " + this.getName() + " process.");
                try {
                    this.process.destroy();
                }
                catch (Throwable t) {
                    LOG.error("Error while trying to destroy process.", t);
                }
                finally {
                    this.process = null;
                    if (this.shutdownHook != null && this.shutdownHook != Thread.currentThread()) {
                        try {
                            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        }
                        catch (IllegalStateException illegalStateException) {
                        }
                        catch (Throwable t) {
                            LOG.warn("Exception while unregistering prcess cleanup shutdown hook.");
                        }
                    }
                }
            }
        }
    }

    public String getProcessOutput() {
        if (this.processOutput != null) {
            return this.processOutput.toString();
        }
        return null;
    }

    public static void touchFile(File file) throws IOException {
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        if (!file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Could not touch the file.");
        }
    }

    public static void waitForMarkerFiles(File basedir, String prefix, int num, long timeout) {
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        while (now < deadline) {
            boolean allFound = true;
            for (int i = 0; i < num; ++i) {
                File nextToCheck = new File(basedir, prefix + i);
                if (nextToCheck.exists()) continue;
                allFound = false;
                break;
            }
            if (allFound) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            now = System.currentTimeMillis();
        }
        Assert.fail((String)("The tasks were not started within time (" + timeout + "msecs)"));
    }
}

