/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilTest {
    @Test
    public void testLog2Computation() {
        Assert.assertEquals((long)0L, (long)MathUtils.log2floor((int)1));
        Assert.assertEquals((long)1L, (long)MathUtils.log2floor((int)2));
        Assert.assertEquals((long)1L, (long)MathUtils.log2floor((int)3));
        Assert.assertEquals((long)2L, (long)MathUtils.log2floor((int)4));
        Assert.assertEquals((long)2L, (long)MathUtils.log2floor((int)5));
        Assert.assertEquals((long)2L, (long)MathUtils.log2floor((int)7));
        Assert.assertEquals((long)3L, (long)MathUtils.log2floor((int)8));
        Assert.assertEquals((long)3L, (long)MathUtils.log2floor((int)9));
        Assert.assertEquals((long)4L, (long)MathUtils.log2floor((int)16));
        Assert.assertEquals((long)4L, (long)MathUtils.log2floor((int)17));
        Assert.assertEquals((long)13L, (long)MathUtils.log2floor((int)8193));
        Assert.assertEquals((long)30L, (long)MathUtils.log2floor((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)31L, (long)MathUtils.log2floor((int)-1));
        try {
            MathUtils.log2floor((int)0);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundDownToPowerOf2() {
        Assert.assertEquals((long)0L, (long)MathUtils.roundDownToPowerOf2((int)0));
        Assert.assertEquals((long)1L, (long)MathUtils.roundDownToPowerOf2((int)1));
        Assert.assertEquals((long)2L, (long)MathUtils.roundDownToPowerOf2((int)2));
        Assert.assertEquals((long)2L, (long)MathUtils.roundDownToPowerOf2((int)3));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)4));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)5));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)6));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)7));
        Assert.assertEquals((long)8L, (long)MathUtils.roundDownToPowerOf2((int)8));
        Assert.assertEquals((long)8L, (long)MathUtils.roundDownToPowerOf2((int)9));
        Assert.assertEquals((long)8L, (long)MathUtils.roundDownToPowerOf2((int)15));
        Assert.assertEquals((long)16L, (long)MathUtils.roundDownToPowerOf2((int)16));
        Assert.assertEquals((long)16L, (long)MathUtils.roundDownToPowerOf2((int)17));
        Assert.assertEquals((long)16L, (long)MathUtils.roundDownToPowerOf2((int)31));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)32));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)33));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)42));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)63));
        Assert.assertEquals((long)64L, (long)MathUtils.roundDownToPowerOf2((int)64));
        Assert.assertEquals((long)64L, (long)MathUtils.roundDownToPowerOf2((int)125));
        Assert.assertEquals((long)16384L, (long)MathUtils.roundDownToPowerOf2((int)25654));
        Assert.assertEquals((long)0x2000000L, (long)MathUtils.roundDownToPowerOf2((int)34366363));
        Assert.assertEquals((long)0x2000000L, (long)MathUtils.roundDownToPowerOf2((int)63463463));
        Assert.assertEquals((long)0x40000000L, (long)MathUtils.roundDownToPowerOf2((int)1852987883));
        Assert.assertEquals((long)0x40000000L, (long)MathUtils.roundDownToPowerOf2((int)Integer.MAX_VALUE));
    }

    @Test
    public void testPowerOfTwo() {
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)1L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)2L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)4L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)8L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)32768L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)65536L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x40000000L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x80000000L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x20000000000L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x4000000000000000L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)3L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)5L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)567923L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)Long.MAX_VALUE));
    }
}

