/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.runtime.util.UnionIterator;
import org.apache.flink.util.TraversableOnceException;
import org.junit.Assert;
import org.junit.Test;

public class UnionIteratorTest {
    @Test
    public void testUnion() {
        try {
            UnionIterator iter = new UnionIterator();
            Assert.assertFalse((boolean)iter.iterator().hasNext());
            iter.clear();
            try {
                iter.iterator().next();
                Assert.fail((String)"should fail with an exception");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            iter.clear();
            iter.addList(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
            iter.addList(Collections.emptyList());
            iter.addList(Arrays.asList(8, 9, 10, 11));
            int val = 1;
            Iterator i$ = iter.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                Assert.assertEquals((long)val++, (long)i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraversableOnce() {
        try {
            UnionIterator iter = new UnionIterator();
            iter.iterator();
            try {
                iter.iterator();
                Assert.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            try {
                iter.iterator();
                Assert.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            iter.clear();
            iter.iterator();
            try {
                iter.iterator();
                Assert.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            try {
                iter.iterator();
                Assert.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            iter.clear();
            iter.addList(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
            Iterator ints = iter.iterator();
            Assert.assertNotNull(ints.next());
            Assert.assertNotNull(ints.next());
            Assert.assertNotNull(ints.next());
            try {
                iter.iterator();
                Assert.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            iter.clear();
            Assert.assertFalse((boolean)iter.iterator().hasNext());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

