/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.checkpoint.StateStore;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

class HeapStateStore<T extends Serializable>
implements StateStore<T> {
    private final ConcurrentMap<String, T> stateMap = new ConcurrentHashMap<String, T>();
    private final AtomicInteger idCounter = new AtomicInteger();

    HeapStateStore() {
    }

    @Override
    public String putState(T state) throws Exception {
        Preconditions.checkNotNull(state, "State");
        String key = "jobmanager://savepoints/" + this.idCounter.incrementAndGet();
        this.stateMap.put(key, state);
        return key;
    }

    @Override
    public T getState(String path) throws Exception {
        Serializable state = (Serializable)this.stateMap.get(path);
        if (state != null) {
            return (T)state;
        }
        throw new IllegalArgumentException("Invalid path '" + path + "'.");
    }

    @Override
    public void disposeState(String path) throws Exception {
        Serializable state = (Serializable)this.stateMap.remove(path);
        if (state == null) {
            throw new IllegalArgumentException("Invalid path '" + path + "'.");
        }
    }

    Collection<T> getAll() {
        return this.stateMap.values();
    }

    void clearAll() {
        this.stateMap.clear();
    }
}

