/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputChannelDeploymentDescriptor
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(InputChannelDeploymentDescriptor.class);
    private final ResultPartitionID consumedPartitionId;
    private final ResultPartitionLocation consumedPartitionLocation;

    public InputChannelDeploymentDescriptor(ResultPartitionID consumedPartitionId, ResultPartitionLocation consumedPartitionLocation) {
        this.consumedPartitionId = Preconditions.checkNotNull(consumedPartitionId);
        this.consumedPartitionLocation = Preconditions.checkNotNull(consumedPartitionLocation);
    }

    public ResultPartitionID getConsumedPartitionId() {
        return this.consumedPartitionId;
    }

    public ResultPartitionLocation getConsumedPartitionLocation() {
        return this.consumedPartitionLocation;
    }

    public String toString() {
        return String.format("InputChannelDeploymentDescriptor [consumed partition id: %s, consumed partition location: %s]", this.consumedPartitionId, this.consumedPartitionLocation);
    }

    public static InputChannelDeploymentDescriptor[] fromEdges(ExecutionEdge[] edges, SimpleSlot consumerSlot) {
        Object[] icdd = new InputChannelDeploymentDescriptor[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            ResultPartitionLocation partitionLocation;
            IntermediateResultPartition consumedPartition = edges[i].getSource();
            Execution producer = consumedPartition.getProducer().getCurrentExecutionAttempt();
            ExecutionState producerState = producer.getState();
            SimpleSlot producerSlot = producer.getAssignedResource();
            if (consumedPartition.isConsumable() && producerSlot != null && (producerState == ExecutionState.RUNNING || producerState == ExecutionState.FINISHED)) {
                Instance partitionInstance = producerSlot.getInstance();
                if (partitionInstance.equals(consumerSlot.getInstance())) {
                    partitionLocation = ResultPartitionLocation.createLocal();
                } else {
                    ConnectionID connectionId = new ConnectionID(partitionInstance.getInstanceConnectionInfo(), consumedPartition.getIntermediateResult().getConnectionIndex());
                    partitionLocation = ResultPartitionLocation.createRemote(connectionId);
                }
            } else {
                partitionLocation = ResultPartitionLocation.createUnknown();
            }
            ResultPartitionID consumedPartitionId = new ResultPartitionID(consumedPartition.getPartitionId(), producer.getAttemptId());
            icdd[i] = new InputChannelDeploymentDescriptor(consumedPartitionId, partitionLocation);
        }
        LOG.debug("Created {} from edges {}.", (Object)Arrays.toString(icdd), (Object)Arrays.toString(edges));
        return icdd;
    }
}

