/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpillableSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewAsyncIO;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewSyncIO;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpillableSubpartition
extends ResultSubpartition {
    private static final Logger LOG = LoggerFactory.getLogger(SpillableSubpartition.class);
    final ArrayList<Buffer> buffers = new ArrayList();
    final IOManager ioManager;
    final IOManager.IOMode ioMode;
    BufferFileWriter spillWriter;
    private boolean isFinished;
    private volatile boolean isReleased;
    private ResultSubpartitionView readView;

    SpillableSubpartition(int index, ResultPartition parent, IOManager ioManager, IOManager.IOMode ioMode) {
        super(index, parent);
        this.ioManager = Preconditions.checkNotNull(ioManager);
        this.ioMode = Preconditions.checkNotNull(ioMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Buffer buffer) throws IOException {
        Preconditions.checkNotNull(buffer);
        ArrayList<Buffer> arrayList = this.buffers;
        synchronized (arrayList) {
            if (this.isFinished || this.isReleased) {
                return false;
            }
            if (this.spillWriter == null) {
                this.buffers.add(buffer);
                return true;
            }
        }
        this.spillWriter.writeBlock(buffer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws IOException {
        ArrayList<Buffer> arrayList = this.buffers;
        synchronized (arrayList) {
            if (this.add(EventSerializer.toBuffer(EndOfPartitionEvent.INSTANCE))) {
                this.isFinished = true;
            }
        }
        if (this.spillWriter != null) {
            this.spillWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws IOException {
        ResultSubpartitionView view;
        ArrayList<Buffer> arrayList = this.buffers;
        synchronized (arrayList) {
            if (this.isReleased) {
                return;
            }
            for (Buffer buffer : this.buffers) {
                buffer.recycle();
            }
            this.buffers.clear();
            this.buffers.trimToSize();
            if (this.spillWriter != null) {
                this.spillWriter.closeAndDelete();
            }
            view = this.readView;
            this.readView = null;
            this.isReleased = true;
        }
        if (view != null) {
            view.notifySubpartitionConsumed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int releaseMemory() throws IOException {
        ArrayList<Buffer> arrayList = this.buffers;
        synchronized (arrayList) {
            if (this.spillWriter == null) {
                this.spillWriter = this.ioManager.createBufferFileWriter(this.ioManager.createChannel());
                int numberOfBuffers = this.buffers.size();
                for (int i = 0; i < numberOfBuffers; ++i) {
                    this.spillWriter.writeBlock(this.buffers.remove(0));
                }
                LOG.debug("Spilling {} buffers of {}.", (Object)numberOfBuffers, (Object)this);
                return numberOfBuffers;
            }
        }
        return 0;
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSubpartitionView createReadView(BufferProvider bufferProvider) throws IOException {
        ArrayList<Buffer> arrayList = this.buffers;
        synchronized (arrayList) {
            boolean isSpilled;
            if (!this.isFinished) {
                throw new IllegalStateException("Subpartition has not been finished yet, but blocking subpartitions can only be consumed after they have been finished.");
            }
            if (this.readView != null) {
                throw new IllegalStateException("Subpartition is being or already has been consumed, but we currently allow subpartitions to only be consumed once.");
            }
            boolean bl = isSpilled = this.spillWriter != null && (this.spillWriter.isClosed() || this.spillWriter.getNumberOfOutstandingRequests() == 0);
            this.readView = isSpilled ? (this.ioMode.isSynchronous() ? new SpilledSubpartitionViewSyncIO(this, bufferProvider.getMemorySegmentSize(), this.spillWriter.getChannelID(), 0L) : new SpilledSubpartitionViewAsyncIO(this, bufferProvider, this.ioManager, this.spillWriter.getChannelID(), 0L)) : new SpillableSubpartitionView(this, bufferProvider, this.buffers.size(), this.ioMode);
            return this.readView;
        }
    }

    public String toString() {
        return String.format("SpillableSubpartition [%d number of buffers (%d bytes),finished? %s, read view? %s, spilled? %s]", this.getTotalNumberOfBuffers(), this.getTotalNumberOfBytes(), this.isFinished, this.readView != null, this.spillWriter != null);
    }
}

