/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

public abstract class AbstractFileStateHandle
implements Serializable {
    private static final long serialVersionUID = 350284443258002355L;
    private final Path filePath;
    private transient FileSystem fs;

    protected AbstractFileStateHandle(Path filePath) {
        this.filePath = Objects.requireNonNull(filePath);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public void discardState() throws Exception {
        this.getFileSystem().delete(this.filePath, false);
        try {
            this.getFileSystem().delete(this.filePath.getParent(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected FileSystem getFileSystem() throws IOException {
        if (this.fs == null) {
            this.fs = FileSystem.get((URI)this.filePath.toUri());
        }
        return this.fs;
    }

    protected long getFileSize() throws IOException {
        return this.getFileSystem().getFileStatus(this.filePath).getLen();
    }
}

