/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.util.OperatingSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class BlobServerDeleteTest {
    private final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSingle() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            client.delete(key);
            client.close();
            client = new BlobClient(serverAddress);
            try {
                client.get(key);
                Assert.fail((String)"BLOB should have been deleted");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                client.put(new byte[1]);
                Assert.fail((String)"client should be closed after erroneous operation");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAll() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            JobID jobID = new JobID();
            String name1 = "random name";
            String name2 = "any nyme";
            client.put(jobID, name1, data);
            client.put(jobID, name2, new byte[712]);
            client.deleteAll(jobID);
            client.close();
            client = new BlobClient(serverAddress);
            try {
                client.get(jobID, name1);
                Assert.fail((String)"BLOB should have been deleted");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                client.put(new byte[1]);
                Assert.fail((String)"client should be closed after erroneous operation");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            client = new BlobClient(serverAddress);
            try {
                client.get(jobID, name2);
                Assert.fail((String)"BLOB should have been deleted");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAlreadyDeletedByBlobKey() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(key);
            Assert.assertTrue((boolean)blobFile.delete());
            try {
                client.delete(key);
            }
            catch (IOException e) {
                Assert.fail((String)"DELETE operation should not fail if file is already deleted");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAlreadyDeletedByName() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            JobID jid = new JobID();
            String name = "------------fdghljEgRJHF+##4U789Q345";
            client.put(jid, name, data);
            File blobFile = server.getStorageLocation(jid, name);
            Assert.assertTrue((boolean)blobFile.delete());
            try {
                client.delete(jid, name);
            }
            catch (IOException e) {
                Assert.fail((String)"DELETE operation should not fail if file is already deleted");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testDeleteFails() {
        block17: {
            Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
            BlobServer server = null;
            BlobClient client = null;
            try {
                Configuration config = new Configuration();
                server = new BlobServer(config);
                InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
                client = new BlobClient(serverAddress);
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                BlobKey key = client.put(data);
                Assert.assertNotNull((Object)key);
                File blobFile = server.getStorageLocation(key);
                File directory = blobFile.getParentFile();
                Assert.assertTrue((boolean)blobFile.setWritable(false, false));
                Assert.assertTrue((boolean)directory.setWritable(false, false));
                try {
                    client.delete(key);
                    Assert.fail((String)"DELETE operation should fail if file cannot be deleted");
                    blobFile.setWritable(true, false);
                }
                catch (IOException iOException) {
                    blobFile.setWritable(true, false);
                    directory.setWritable(true, false);
                    break block17;
                    catch (Throwable throwable) {
                        blobFile.setWritable(true, false);
                        directory.setWritable(true, false);
                        throw throwable;
                    }
                }
                directory.setWritable(true, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
            }
        }
    }
}

