/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import akka.actor.ActorSystem;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.HeapStateStore;
import org.apache.flink.runtime.checkpoint.SavepointCoordinator;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StateStore;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.stats.DisabledCheckpointStatsTracker;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class ExecutionGraphCheckpointCoordinatorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointAndSavepointCoordinatorShareCheckpointIDCounter() throws Exception {
        ExecutionGraph executionGraph = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), new JobID(), "test", new Configuration(), new FiniteDuration(1L, TimeUnit.DAYS), (RestartStrategy)new NoRestartStrategy(), Collections.emptyList(), Collections.emptyList(), ClassLoader.getSystemClassLoader());
        ActorSystem actorSystem = AkkaUtils.createDefaultActorSystem();
        try {
            executionGraph.enableSnapshotCheckpointing(100L, 100L, 100L, 1, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), actorSystem, UUID.randomUUID(), (CheckpointIDCounter)new StandaloneCheckpointIDCounter(), (CompletedCheckpointStore)new StandaloneCompletedCheckpointStore(1, ClassLoader.getSystemClassLoader()), RecoveryMode.STANDALONE, (StateStore)new HeapStateStore(), (CheckpointStatsTracker)new DisabledCheckpointStatsTracker());
            CheckpointCoordinator checkpointCoordinator = executionGraph.getCheckpointCoordinator();
            SavepointCoordinator savepointCoordinator = executionGraph.getSavepointCoordinator();
            Field counterField = CheckpointCoordinator.class.getDeclaredField("checkpointIdCounter");
            CheckpointIDCounter counterCheckpointCoordinator = (CheckpointIDCounter)counterField.get(checkpointCoordinator);
            CheckpointIDCounter counterSavepointCoordinator = (CheckpointIDCounter)counterField.get(savepointCoordinator);
            Assert.assertEquals((Object)counterCheckpointCoordinator, (Object)counterSavepointCoordinator);
        }
        finally {
            if (actorSystem != null) {
                actorSystem.shutdown();
            }
        }
    }
}

