/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.AbstractStateStoreTest;
import org.apache.flink.runtime.checkpoint.FileSystemStateStore;
import org.apache.flink.runtime.checkpoint.StateStore;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class FileSystemStateStoreTest
extends AbstractStateStoreTest {
    private static File rootPath;

    @BeforeClass
    public static void setUp() throws Exception {
        rootPath = CommonTestUtils.createTempDirectory();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (rootPath != null) {
            try {
                String errMsg = "Root path " + rootPath.getPath() + " not cleaned up. " + Arrays.toString(rootPath.listFiles());
                Assert.assertFalse((String)errMsg, (boolean)rootPath.exists());
            }
            finally {
                FileUtils.deleteDirectory((File)rootPath);
            }
        }
    }

    @Override
    StateStore<Integer> createStateStore() throws Exception {
        return new FileSystemStateStore(new Path(rootPath.toURI()), "test_savepoint-");
    }

    @Override
    boolean verifyDiscarded(StateStore<Integer> stateStore, String path) {
        return true;
    }
}

