/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.FileSystemStateStore;
import org.apache.flink.runtime.checkpoint.HeapStateStore;
import org.apache.flink.runtime.checkpoint.SavepointStore;
import org.apache.flink.runtime.checkpoint.SavepointStoreFactory;
import org.junit.Assert;
import org.junit.Test;

public class SavepointStoreFactoryTest {
    @Test
    public void testStateStoreWithDefaultConfig() throws Exception {
        SavepointStore store = SavepointStoreFactory.createFromConfig((Configuration)new Configuration());
        Assert.assertTrue((boolean)(store.getStateStore() instanceof HeapStateStore));
    }

    @Test
    public void testSavepointBackendJobManager() throws Exception {
        Configuration config = new Configuration();
        config.setString("savepoints.state.backend", "jobmanager");
        SavepointStore store = SavepointStoreFactory.createFromConfig((Configuration)config);
        Assert.assertTrue((boolean)(store.getStateStore() instanceof HeapStateStore));
    }

    @Test
    public void testSavepointBackendFileSystem() throws Exception {
        Configuration config = new Configuration();
        String rootPath = System.getProperty("java.io.tmpdir");
        config.setString("state.backend", "filesystem");
        config.setString("savepoints.state.backend", "filesystem");
        config.setString("savepoints.state.backend.fs.dir", rootPath);
        SavepointStore store = SavepointStoreFactory.createFromConfig((Configuration)config);
        Assert.assertTrue((boolean)(store.getStateStore() instanceof FileSystemStateStore));
        FileSystemStateStore stateStore = (FileSystemStateStore)store.getStateStore();
        Assert.assertEquals((Object)new Path(rootPath), (Object)stateStore.getRootPath());
    }

    @Test
    public void testSavepointBackendFileSystemButCheckpointBackendJobManager() throws Exception {
        Configuration config = new Configuration();
        String rootPath = System.getProperty("java.io.tmpdir");
        config.setString("state.backend", "jobmanager");
        config.setString("savepoints.state.backend", "filesystem");
        config.setString("savepoints.state.backend.fs.dir", rootPath);
        SavepointStore store = SavepointStoreFactory.createFromConfig((Configuration)config);
        Assert.assertTrue((boolean)(store.getStateStore() instanceof FileSystemStateStore));
        FileSystemStateStore stateStore = (FileSystemStateStore)store.getStateStore();
        Assert.assertEquals((Object)new Path(rootPath), (Object)stateStore.getRootPath());
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testSavepointBackendFileSystemButNoDirectory() throws Exception {
        Configuration config = new Configuration();
        config.setString("savepoints.state.backend", "filesystem");
        SavepointStoreFactory.createFromConfig((Configuration)config);
        Assert.fail((String)"Did not throw expected Exception");
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testUnexpectedSavepointBackend() throws Exception {
        Configuration config = new Configuration();
        config.setString("savepoints.state.backend", "unexpected");
        SavepointStoreFactory.createFromConfig((Configuration)config);
        Assert.fail((String)"Did not throw expected Exception");
    }
}

