/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.client.SerializedJobExecutionResult;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class SerializedJobExecutionResultTest {
    @Test
    public void testSerialization() {
        try {
            ClassLoader classloader = this.getClass().getClassLoader();
            JobID origJobId = new JobID();
            long origTime = 65927436589267L;
            HashMap<String, SerializedValue> origMap = new HashMap<String, SerializedValue>();
            origMap.put("name1", new SerializedValue((Object)723L));
            origMap.put("name2", new SerializedValue((Object)"peter"));
            SerializedJobExecutionResult result = new SerializedJobExecutionResult(origJobId, origTime, origMap);
            SerializedJobExecutionResult cloned = (SerializedJobExecutionResult)CommonTestUtils.createCopySerializable((Serializable)result);
            Assert.assertEquals((Object)origJobId, (Object)cloned.getJobId());
            Assert.assertEquals((long)origTime, (long)cloned.getNetRuntime());
            Assert.assertEquals((long)origTime, (long)cloned.getNetRuntime(TimeUnit.MILLISECONDS));
            Assert.assertEquals(origMap, (Object)cloned.getSerializedAccumulatorResults());
            JobExecutionResult jResult = result.toJobExecutionResult(classloader);
            JobExecutionResult jResultCopied = result.toJobExecutionResult(classloader);
            Assert.assertEquals((Object)origJobId, (Object)jResult.getJobID());
            Assert.assertEquals((Object)origJobId, (Object)jResultCopied.getJobID());
            Assert.assertEquals((long)origTime, (long)jResult.getNetRuntime());
            Assert.assertEquals((long)origTime, (long)jResult.getNetRuntime(TimeUnit.MILLISECONDS));
            Assert.assertEquals((long)origTime, (long)jResultCopied.getNetRuntime());
            Assert.assertEquals((long)origTime, (long)jResultCopied.getNetRuntime(TimeUnit.MILLISECONDS));
            for (Map.Entry entry : origMap.entrySet()) {
                String name = (String)entry.getKey();
                Object value = ((SerializedValue)entry.getValue()).deserializeValue(classloader);
                Assert.assertEquals((Object)value, (Object)jResult.getAccumulatorResult(name));
                Assert.assertEquals((Object)value, (Object)jResultCopied.getAccumulatorResult(name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerializationWithNullValues() {
        try {
            SerializedJobExecutionResult result = new SerializedJobExecutionResult(null, 0L, null);
            SerializedJobExecutionResult cloned = (SerializedJobExecutionResult)CommonTestUtils.createCopySerializable((Serializable)result);
            Assert.assertNull((Object)cloned.getJobId());
            Assert.assertEquals((long)0L, (long)cloned.getNetRuntime());
            Assert.assertNull((Object)cloned.getSerializedAccumulatorResults());
            JobExecutionResult jResult = result.toJobExecutionResult(this.getClass().getClassLoader());
            Assert.assertNull((Object)jResult.getJobID());
            Assert.assertTrue((boolean)jResult.getAllAccumulatorResults().isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

