/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Arrays;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.executiongraph.AllVerticesIterator;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AllVerticesIteratorTest {
    @Test
    public void testAllVertices() {
        try {
            JobVertex v1 = new JobVertex("v1");
            JobVertex v2 = new JobVertex("v2");
            JobVertex v3 = new JobVertex("v3");
            JobVertex v4 = new JobVertex("v4");
            v1.setParallelism(1);
            v2.setParallelism(7);
            v3.setParallelism(3);
            v4.setParallelism(2);
            ExecutionGraph eg = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
            Mockito.when((Object)eg.getExecutionContext()).thenReturn((Object)TestingUtils.directExecutionContext());
            ExecutionJobVertex ejv1 = new ExecutionJobVertex(eg, v1, 1, AkkaUtils.getDefaultTimeout());
            ExecutionJobVertex ejv2 = new ExecutionJobVertex(eg, v2, 1, AkkaUtils.getDefaultTimeout());
            ExecutionJobVertex ejv3 = new ExecutionJobVertex(eg, v3, 1, AkkaUtils.getDefaultTimeout());
            ExecutionJobVertex ejv4 = new ExecutionJobVertex(eg, v4, 1, AkkaUtils.getDefaultTimeout());
            AllVerticesIterator iter = new AllVerticesIterator(Arrays.asList(ejv1, ejv2, ejv3, ejv4).iterator());
            int numReturned = 0;
            while (iter.hasNext()) {
                iter.hasNext();
                Assert.assertNotNull((Object)iter.next());
                ++numReturned;
            }
            Assert.assertEquals((long)13L, (long)numReturned);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

