/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Arrays;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.concurrent.ExecutionContext;

public class ExecutionStateProgressTest {
    @Test
    public void testAccumulatedStateFinished() {
        try {
            JobID jid = new JobID();
            JobVertexID vid = new JobVertexID();
            JobVertex ajv = new JobVertex("TestVertex", vid);
            ajv.setParallelism(3);
            ajv.setInvokableClass(((AbstractInvokable)Mockito.mock(AbstractInvokable.class)).getClass());
            ExecutionGraph graph = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jid, "test job", new Configuration(), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy());
            graph.attachJobGraph(Arrays.asList(ajv));
            ExecutionGraphTestUtils.setGraphStatus(graph, JobStatus.RUNNING);
            ExecutionJobVertex ejv = graph.getJobVertex(vid);
            for (ExecutionVertex ee : ejv.getTaskVertices()) {
                SimpleSlot slot = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleActorGateway((ExecutionContext)TestingUtils.defaultExecutionContext())).allocateSimpleSlot(jid);
                ee.deployToSlot(slot);
            }
            for (ExecutionVertex ee : ejv.getTaskVertices()) {
                ee.executionFinished();
            }
            Assert.assertTrue((boolean)ejv.isInFinalState());
            Assert.assertEquals((Object)JobStatus.FINISHED, (Object)graph.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

