/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAllocationFuture;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import scala.concurrent.ExecutionContext;

public class ExecutionVertexSchedulingTest {
    @Test
    public void testSlotReleasedWhenScheduledImmediately() {
        try {
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(new JobVertexID());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Instance instance = ExecutionGraphTestUtils.getInstance(DummyActorGateway.INSTANCE);
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            slot.releaseSlot();
            Assert.assertTrue((boolean)slot.isReleased());
            Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
            Mockito.when((Object)scheduler.scheduleImmediately((ScheduledUnit)Matchers.any(ScheduledUnit.class))).thenReturn((Object)slot);
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.scheduleForExecution(scheduler, false);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSlotReleasedWhenScheduledQueued() {
        try {
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(new JobVertexID());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Instance instance = ExecutionGraphTestUtils.getInstance(DummyActorGateway.INSTANCE);
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            slot.releaseSlot();
            Assert.assertTrue((boolean)slot.isReleased());
            SlotAllocationFuture future = new SlotAllocationFuture();
            Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
            Mockito.when((Object)scheduler.scheduleQueued((ScheduledUnit)Matchers.any(ScheduledUnit.class))).thenReturn((Object)future);
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.scheduleForExecution(scheduler, true);
            Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)vertex.getExecutionState());
            future.setSlot(slot);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleToDeploying() {
        try {
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(new JobVertexID());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleActorGateway((ExecutionContext)TestingUtils.defaultExecutionContext()));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
            Mockito.when((Object)scheduler.scheduleImmediately((ScheduledUnit)Matchers.any(ScheduledUnit.class))).thenReturn((Object)slot);
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.scheduleForExecution(scheduler, false);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

