/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.IntValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PrepareForTest(value={ResultPartitionWriter.class})
@RunWith(value=PowerMockRunner.class)
public class RecordWriterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearBuffersAfterInterruptDuringBlockingBufferRequest() throws Exception {
        ExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadExecutor();
            final CountDownLatch sync = new CountDownLatch(2);
            final Buffer buffer = (Buffer)Mockito.spy((Object)TestBufferFactory.createBuffer(4));
            Answer<Buffer> request = new Answer<Buffer>(){

                public Buffer answer(InvocationOnMock invocation) throws Throwable {
                    Object o;
                    sync.countDown();
                    if (sync.getCount() == 1L) {
                        return buffer;
                    }
                    Object object = o = new Object();
                    synchronized (object) {
                        while (true) {
                            o.wait();
                        }
                    }
                }
            };
            BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
            Mockito.when((Object)bufferProvider.requestBufferBlocking()).thenAnswer((Answer)request);
            ResultPartitionWriter partitionWriter = this.createResultPartitionWriter(bufferProvider);
            final RecordWriter recordWriter = new RecordWriter(partitionWriter);
            Future<Void> result = executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IntValue val = new IntValue(0);
                    try {
                        recordWriter.emit((IOReadableWritable)val);
                        recordWriter.flush();
                        recordWriter.emit((IOReadableWritable)val);
                    }
                    catch (InterruptedException e) {
                        recordWriter.clearBuffers();
                    }
                    return null;
                }
            });
            sync.await();
            result.cancel(true);
            recordWriter.clearBuffers();
            ((BufferProvider)Mockito.verify((Object)bufferProvider, (VerificationMode)Mockito.times((int)2))).requestBufferBlocking();
            ((ResultPartitionWriter)Mockito.verify((Object)partitionWriter, (VerificationMode)Mockito.times((int)1))).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
            Assert.assertTrue((String)"Buffer not recycled.", (boolean)buffer.isRecycled());
            ((Buffer)Mockito.verify((Object)buffer, (VerificationMode)Mockito.times((int)1))).recycle();
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearBuffersAfterExceptionInPartitionWriter() throws Exception {
        NetworkBufferPool buffers = null;
        BufferPool bufferPool = null;
        try {
            buffers = new NetworkBufferPool(1, 1024, MemoryType.HEAP);
            bufferPool = (BufferPool)Mockito.spy((Object)buffers.createBufferPool(1, true));
            ResultPartitionWriter partitionWriter = (ResultPartitionWriter)Mockito.mock(ResultPartitionWriter.class);
            Mockito.when((Object)partitionWriter.getBufferProvider()).thenReturn(Preconditions.checkNotNull((Object)bufferPool));
            Mockito.when((Object)partitionWriter.getNumberOfOutputChannels()).thenReturn((Object)1);
            ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    Buffer buffer = (Buffer)invocation.getArguments()[0];
                    buffer.recycle();
                    throw new RuntimeException("Expected test Exception");
                }
            }).when((Object)partitionWriter)).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
            RecordWriter recordWriter = new RecordWriter(partitionWriter);
            try {
                while (true) {
                    recordWriter.emit((IOReadableWritable)new IntValue(0));
                }
            }
            catch (Exception e) {
                recordWriter.clearBuffers();
                ((ResultPartitionWriter)Mockito.verify((Object)partitionWriter, (VerificationMode)Mockito.times((int)1))).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
                ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).requestBufferBlocking();
                try {
                    recordWriter.emit((IOReadableWritable)new IntValue(0));
                    recordWriter.flush();
                    Assert.fail((String)"Did not throw expected test Exception");
                }
                catch (Exception e2) {
                    recordWriter.clearBuffers();
                }
                ((ResultPartitionWriter)Mockito.verify((Object)partitionWriter, (VerificationMode)Mockito.times((int)2))).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
                ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)2))).requestBufferBlocking();
                try {
                    while (true) {
                        recordWriter.broadcastEmit((IOReadableWritable)new IntValue(0));
                    }
                }
                catch (Exception e3) {
                    recordWriter.clearBuffers();
                    ((ResultPartitionWriter)Mockito.verify((Object)partitionWriter, (VerificationMode)Mockito.times((int)3))).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
                    ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)3))).requestBufferBlocking();
                    try {
                        recordWriter.emit((IOReadableWritable)new IntValue(0));
                        recordWriter.sendEndOfSuperstep();
                        Assert.fail((String)"Did not throw expected test Exception");
                    }
                    catch (Exception e4) {
                        recordWriter.clearBuffers();
                    }
                    ((ResultPartitionWriter)Mockito.verify((Object)partitionWriter, (VerificationMode)Mockito.times((int)4))).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
                    ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)4))).requestBufferBlocking();
                    try {
                        recordWriter.emit((IOReadableWritable)new IntValue(0));
                        recordWriter.broadcastEvent((AbstractEvent)new TestTaskEvent());
                        Assert.fail((String)"Did not throw expected test Exception");
                    }
                    catch (Exception e5) {
                        recordWriter.clearBuffers();
                    }
                    ((ResultPartitionWriter)Mockito.verify((Object)partitionWriter, (VerificationMode)Mockito.times((int)5))).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
                    ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)5))).requestBufferBlocking();
                    if (bufferPool != null) {
                        Assert.assertEquals((long)1L, (long)bufferPool.getNumberOfAvailableMemorySegments());
                        bufferPool.lazyDestroy();
                    }
                    if (buffers != null) {
                        Assert.assertEquals((long)1L, (long)buffers.getNumberOfAvailableMemorySegments());
                        buffers.destroy();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (bufferPool != null) {
                Assert.assertEquals((long)1L, (long)bufferPool.getNumberOfAvailableMemorySegments());
                bufferPool.lazyDestroy();
            }
            if (buffers != null) {
                Assert.assertEquals((long)1L, (long)buffers.getNumberOfAvailableMemorySegments());
                buffers.destroy();
            }
            throw throwable;
        }
    }

    @Test
    public void testSerializerClearedAfterClearBuffers() throws Exception {
        Buffer buffer = TestBufferFactory.createBuffer(16);
        ResultPartitionWriter partitionWriter = this.createResultPartitionWriter(this.createBufferProvider(buffer));
        RecordWriter recordWriter = new RecordWriter(partitionWriter);
        recordWriter.emit((IOReadableWritable)new IntValue(0));
        ((ResultPartitionWriter)Mockito.verify((Object)partitionWriter, (VerificationMode)Mockito.never())).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
        recordWriter.clearBuffers();
        recordWriter.flush();
    }

    private BufferProvider createBufferProvider(Buffer ... buffers) throws IOException, InterruptedException {
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        for (int i = 0; i < buffers.length; ++i) {
            Mockito.when((Object)bufferProvider.requestBufferBlocking()).thenReturn((Object)buffers[i]);
        }
        return bufferProvider;
    }

    private ResultPartitionWriter createResultPartitionWriter(BufferProvider bufferProvider) throws IOException {
        ResultPartitionWriter partitionWriter = (ResultPartitionWriter)Mockito.mock(ResultPartitionWriter.class);
        Mockito.when((Object)partitionWriter.getBufferProvider()).thenReturn(Preconditions.checkNotNull((Object)bufferProvider));
        Mockito.when((Object)partitionWriter.getNumberOfOutputChannels()).thenReturn((Object)1);
        ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ((Buffer)invocation.getArguments()[0]).recycle();
                return null;
            }
        }).when((Object)partitionWriter)).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
        return partitionWriter;
    }
}

