/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewAsyncIO;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewSyncIO;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestInfiniteBufferProvider;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.runtime.io.network.util.TestSubpartitionConsumer;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class SpilledSubpartitionViewTest {
    private static final IOManager ioManager = new IOManagerAsync();
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final TestInfiniteBufferProvider writerBufferPool = new TestInfiniteBufferProvider();
    private IOManager.IOMode ioMode;

    public SpilledSubpartitionViewTest(IOManager.IOMode ioMode) {
        this.ioMode = ioMode;
    }

    @AfterClass
    public static void shutdown() {
        ioManager.shutdown();
        executor.shutdown();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> ioMode() {
        return Arrays.asList({IOManager.IOMode.SYNC}, {IOManager.IOMode.ASYNC});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testReadMultipleFilesWithSingleBufferPool() throws Exception {
        BufferFileWriter[] writers = new BufferFileWriter[]{SpilledSubpartitionViewTest.createWriterAndWriteBuffers(ioManager, writerBufferPool, 512), SpilledSubpartitionViewTest.createWriterAndWriteBuffers(ioManager, writerBufferPool, 512)};
        ResultSubpartitionView[] readers = new ResultSubpartitionView[writers.length];
        TestPooledBufferProvider inputBuffers = new TestPooledBufferProvider(2);
        ResultSubpartition parent = (ResultSubpartition)Mockito.mock(ResultSubpartition.class);
        try {
            void var8_15;
            for (BufferFileWriter bufferFileWriter : writers) {
                bufferFileWriter.close();
            }
            for (int i = 0; i < readers.length; ++i) {
                readers[i] = this.ioMode.isSynchronous() ? new SpilledSubpartitionViewSyncIO(parent, inputBuffers.getMemorySegmentSize(), writers[i].getChannelID(), 0L) : new SpilledSubpartitionViewAsyncIO(parent, (BufferProvider)inputBuffers, ioManager, writers[i].getChannelID(), 0L);
            }
            ArrayList results = Lists.newArrayList();
            ResultSubpartitionView[] resultSubpartitionViewArray = readers;
            int n = resultSubpartitionViewArray.length;
            boolean bl = false;
            while (var8_15 < n) {
                ResultSubpartitionView view = resultSubpartitionViewArray[var8_15];
                results.add(executor.submit(new TestSubpartitionConsumer(view, false, new TestConsumerCallback.RecyclingCallback())));
                ++var8_15;
            }
            for (Future res : results) {
                try {
                    res.get(2L, TimeUnit.MINUTES);
                }
                catch (TimeoutException timeoutException) {
                    throw new TimeoutException("There has been a timeout in the test. This indicates that there is a bug/deadlock in the tested subpartition view. The timed out test was in " + this.ioMode + " mode.");
                    return;
                }
            }
        }
        finally {
            for (BufferFileWriter bufferFileWriter : writers) {
                if (bufferFileWriter == null) continue;
                bufferFileWriter.deleteChannel();
            }
            for (BufferFileWriter bufferFileWriter : readers) {
                if (bufferFileWriter == null) continue;
                bufferFileWriter.releaseAllResources();
            }
        }
    }

    static BufferFileWriter createWriterAndWriteBuffers(IOManager ioManager, BufferProvider bufferProvider, int numberOfBuffers) throws IOException {
        BufferFileWriter writer = ioManager.createBufferFileWriter(ioManager.createChannel());
        for (int i = 0; i < numberOfBuffers; ++i) {
            writer.writeBlock((Object)bufferProvider.requestBuffer());
        }
        writer.writeBlock((Object)EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE));
        return writer;
    }
}

