/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.io.network.util.TestInfiniteBufferProvider;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class SubpartitionTestBase
extends TestLogger {
    abstract ResultSubpartition createSubpartition();

    @Test
    public void testAddAfterFinish() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.finish();
            Assert.assertFalse((boolean)subpartition.add((Buffer)Mockito.mock(Buffer.class)));
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testAddAfterRelease() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.release();
            Assert.assertFalse((boolean)subpartition.add((Buffer)Mockito.mock(Buffer.class)));
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testReleaseParent() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        this.verifyViewReleasedAfterParentRelease(partition);
    }

    @Test
    public void testReleaseParentAfterSpilled() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.releaseMemory();
        this.verifyViewReleasedAfterParentRelease(partition);
    }

    private void verifyViewReleasedAfterParentRelease(ResultSubpartition partition) throws Exception {
        Buffer buffer = TestBufferFactory.createBuffer();
        partition.add(buffer);
        partition.finish();
        TestInfiniteBufferProvider buffers = new TestInfiniteBufferProvider();
        ResultSubpartitionView view = partition.createReadView((BufferProvider)buffers);
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertFalse((boolean)view.isReleased());
        partition.release();
        Assert.assertTrue((boolean)view.isReleased());
    }
}

