/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.GenericPairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.hash.ReusingBuildFirstHashJoinIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildSecondHashJoinIterator;
import org.apache.flink.runtime.operators.sort.ReusingMergeInnerJoinIterator;
import org.apache.flink.runtime.operators.sort.UnilateralSortMerger;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HashVsSortMiniBenchmark {
    private static final int MEMORY_SIZE = 0x2000000;
    private static final int PAGE_SIZE = 32768;
    private static final int MEMORY_PAGES_FOR_MERGE = 10;
    private static final int MEMORY_FOR_SORTER = 16613376;
    private static final int INPUT_1_SIZE = 2000000;
    private static final int INPUT_2_SIZE = 100000;
    private static final long SEED1 = 561349061987311L;
    private static final long SEED2 = 231434613412342L;
    private final AbstractInvokable parentTask = new DummyInvokable();
    private IOManager ioManager;
    private MemoryManager memoryManager;
    private TypeSerializerFactory<Tuple2<Integer, String>> serializer1;
    private TypeSerializerFactory<Tuple2<Integer, String>> serializer2;
    private TypeComparator<Tuple2<Integer, String>> comparator1;
    private TypeComparator<Tuple2<Integer, String>> comparator2;
    private TypePairComparator<Tuple2<Integer, String>, Tuple2<Integer, String>> pairComparator11;

    @Before
    public void beforeTest() {
        this.serializer1 = TestData.getIntStringTupleSerializerFactory();
        this.serializer2 = TestData.getIntStringTupleSerializerFactory();
        this.comparator1 = TestData.getIntStringTupleComparator();
        this.comparator2 = TestData.getIntStringTupleComparator();
        this.pairComparator11 = new GenericPairComparator(this.comparator1, this.comparator2);
        this.memoryManager = new MemoryManager(0x2000000L, 1, 32768, MemoryType.HEAP, true);
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void afterTest() {
        if (this.memoryManager != null) {
            Assert.assertTrue((String)"Memory Leak: Not all memory has been returned to the memory manager.", (boolean)this.memoryManager.verifyEmpty());
            this.memoryManager.shutdown();
            this.memoryManager = null;
        }
        if (this.ioManager != null) {
            this.ioManager.shutdown();
            if (!this.ioManager.isProperlyShutDown()) {
                Assert.fail((String)"I/O manager failed to properly shut down.");
            }
            this.ioManager = null;
        }
    }

    @Test
    public void testSortBothMerge() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 200000, 100, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 100000, 100, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 2000000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 100000);
            NoOpMatcher matcher = new NoOpMatcher();
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            long start = System.nanoTime();
            UnilateralSortMerger sorter1 = new UnilateralSortMerger(this.memoryManager, this.ioManager, (MutableObjectIterator)input1, this.parentTask, this.serializer1, this.comparator1.duplicate(), 0.4951171875, 128, 0.8f, true);
            UnilateralSortMerger sorter2 = new UnilateralSortMerger(this.memoryManager, this.ioManager, (MutableObjectIterator)input2, this.parentTask, this.serializer2, this.comparator2.duplicate(), 0.4951171875, 128, 0.8f, true);
            MutableObjectIterator sortedInput1 = sorter1.getIterator();
            MutableObjectIterator sortedInput2 = sorter2.getIterator();
            ReusingMergeInnerJoinIterator iterator = new ReusingMergeInnerJoinIterator(sortedInput1, sortedInput2, this.serializer1.getSerializer(), this.comparator1, this.serializer2.getSerializer(), this.comparator2, this.pairComparator11, this.memoryManager, this.ioManager, 10, this.parentTask);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            sorter1.close();
            sorter2.close();
            long elapsed = System.nanoTime() - start;
            double msecs = elapsed / 1000000L;
            System.out.println("Sort-Merge Took " + msecs + " msecs.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    public void testBuildFirst() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 200000, 100, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 100000, 100, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 2000000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 100000);
            NoOpMatcher matcher = new NoOpMatcher();
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            long start = System.nanoTime();
            ReusingBuildFirstHashJoinIterator iterator = new ReusingBuildFirstHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.serializer1.getSerializer(), this.comparator1, this.serializer2.getSerializer(), this.comparator2, this.pairComparator11, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            long elapsed = System.nanoTime() - start;
            double msecs = elapsed / 1000000L;
            System.out.println("Hash Build First Took " + msecs + " msecs.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    public void testBuildSecond() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 200000, 100, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 100000, 100, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 2000000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 100000);
            NoOpMatcher matcher = new NoOpMatcher();
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            long start = System.nanoTime();
            ReusingBuildSecondHashJoinIterator iterator = new ReusingBuildSecondHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.serializer1.getSerializer(), this.comparator1, this.serializer2.getSerializer(), this.comparator2, this.pairComparator11, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            long elapsed = System.nanoTime() - start;
            double msecs = elapsed / 1000000L;
            System.out.println("Hash Build Second took " + msecs + " msecs.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    private static final class NoOpMatcher
    implements FlatJoinFunction<Tuple2<Integer, String>, Tuple2<Integer, String>, Tuple2<Integer, String>> {
        private static final long serialVersionUID = 1L;

        private NoOpMatcher() {
        }

        public void join(Tuple2<Integer, String> rec1, Tuple2<Integer, String> rec2, Collector<Tuple2<Integer, String>> out) throws Exception {
        }
    }
}

