/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import org.apache.flink.runtime.util.ClassLoaderUtil;
import org.apache.flink.runtime.util.JarFileCreator;
import org.junit.Assert;
import org.junit.Test;

public class ClassLoaderUtilsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithURLClassLoader() {
        File validJar = null;
        File invalidJar = null;
        try {
            validJar = File.createTempFile("flink-url-test", ".tmp");
            JarFileCreator jarFileCreator = new JarFileCreator(validJar);
            jarFileCreator.addClass(ClassLoaderUtilsTest.class);
            jarFileCreator.createJarFile();
            try (JarFile jarFile = null;){
                jarFile = new JarFile(validJar.getAbsolutePath());
            }
            invalidJar = File.createTempFile("flink-url-test", ".tmp");
            try (FileOutputStream invalidout = new FileOutputStream(invalidJar);){
                invalidout.write(new byte[]{-1, 1, -2, 3, -3, 4});
            }
            File nonExisting = File.createTempFile("flink-url-test", ".tmp");
            Assert.assertTrue((String)"Cannot create and delete temp file", (boolean)nonExisting.delete());
            URL[] urls = new URL[]{new URL("http", "localhost", 26712, "/some/file/path"), new URL("file", null, validJar.getAbsolutePath()), new URL("file", null, invalidJar.getAbsolutePath()), new URL("file", null, nonExisting.getAbsolutePath())};
            URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
            String info = ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)loader);
            Assert.assertTrue((info.indexOf("/some/file/path") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((info.indexOf(validJar.getAbsolutePath() + "' (valid") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((info.indexOf(invalidJar.getAbsolutePath() + "' (invalid JAR") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((info.indexOf(nonExisting.getAbsolutePath() + "' (missing") > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (validJar != null) {
                validJar.delete();
            }
            if (invalidJar != null) {
                invalidJar.delete();
            }
        }
    }

    @Test
    public void testWithAppClassLoader() {
        try {
            String result = ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)ClassLoader.getSystemClassLoader());
            Assert.assertTrue((boolean)result.toLowerCase().contains("system classloader"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInvalidClassLoaders() {
        try {
            Assert.assertNotNull((Object)ClassLoaderUtil.getUserCodeClassLoaderInfo(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

