/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.util.EnvironmentInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class EnvironmentInformationTest {
    @Test
    public void testJavaMemory() {
        try {
            long fullHeap = EnvironmentInformation.getMaxJvmHeapMemory();
            long freeWithGC = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            Assert.assertTrue((fullHeap > 0L ? 1 : 0) != 0);
            Assert.assertTrue((freeWithGC >= 0L ? 1 : 0) != 0);
            try {
                long free = EnvironmentInformation.getSizeOfFreeHeapMemory();
                Assert.assertTrue((free >= 0L ? 1 : 0) != 0);
            }
            catch (RuntimeException e) {
                Assert.assertEquals((long)Long.MAX_VALUE, (long)EnvironmentInformation.getMaxJvmHeapMemory());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEnvironmentMethods() {
        try {
            Assert.assertNotNull((Object)EnvironmentInformation.getJvmStartupOptions());
            Assert.assertNotNull((Object)EnvironmentInformation.getJvmStartupOptionsArray());
            Assert.assertNotNull((Object)EnvironmentInformation.getJvmVersion());
            Assert.assertNotNull((Object)EnvironmentInformation.getRevisionInformation());
            Assert.assertNotNull((Object)EnvironmentInformation.getVersion());
            Assert.assertNotNull((Object)EnvironmentInformation.getUserRunning());
            Assert.assertTrue((EnvironmentInformation.getOpenFileHandlesLimit() >= -1L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLogEnvironmentInformation() {
        try {
            Logger mockLogger = (Logger)Mockito.mock(Logger.class);
            EnvironmentInformation.logEnvironmentInfo((Logger)mockLogger, (String)"test", (String[])new String[0]);
            EnvironmentInformation.logEnvironmentInfo((Logger)mockLogger, (String)"test", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

