/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorDeActivator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.StateForTask;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.stats.DisabledCheckpointStatsTracker;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.NotifyCheckpointComplete;
import org.apache.flink.runtime.messages.checkpoint.TriggerCheckpoint;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointCoordinator {
    static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private static final int NUM_GHOST_CHECKPOINT_IDS = 16;
    protected final Object lock = new Object();
    private final JobID job;
    private final ExecutionVertex[] tasksToTrigger;
    private final ExecutionVertex[] tasksToWaitFor;
    private final ExecutionVertex[] tasksToCommitTo;
    private final Map<Long, PendingCheckpoint> pendingCheckpoints;
    private final CompletedCheckpointStore completedCheckpointStore;
    private final ArrayDeque<Long> recentPendingCheckpoints;
    protected final CheckpointIDCounter checkpointIdCounter;
    private final ClassLoader userClassLoader;
    private final long baseInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final int maxConcurrentCheckpointAttempts;
    private final Timer timer;
    private ActorGateway jobStatusListener;
    private int numUnsuccessfulCheckpointsTriggers;
    private ScheduledTrigger currentPeriodicTrigger;
    private boolean periodicScheduling;
    private boolean triggerRequestQueued;
    private volatile boolean shutdown;
    private final Thread shutdownHook;
    private final CheckpointStatsTracker statsTracker;

    public CheckpointCoordinator(JobID job, long baseInterval, long checkpointTimeout, ExecutionVertex[] tasksToTrigger, ExecutionVertex[] tasksToWaitFor, ExecutionVertex[] tasksToCommitTo, ClassLoader userClassLoader, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore completedCheckpointStore, RecoveryMode recoveryMode) throws Exception {
        this(job, baseInterval, checkpointTimeout, 0L, Integer.MAX_VALUE, tasksToTrigger, tasksToWaitFor, tasksToCommitTo, userClassLoader, checkpointIDCounter, completedCheckpointStore, recoveryMode, new DisabledCheckpointStatsTracker());
    }

    public CheckpointCoordinator(JobID job, long baseInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpointAttempts, ExecutionVertex[] tasksToTrigger, ExecutionVertex[] tasksToWaitFor, ExecutionVertex[] tasksToCommitTo, ClassLoader userClassLoader, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore completedCheckpointStore, RecoveryMode recoveryMode, CheckpointStatsTracker statsTracker) throws Exception {
        Preconditions.checkArgument(baseInterval > 0L, "Checkpoint timeout must be larger than zero");
        Preconditions.checkArgument(checkpointTimeout >= 1L, "Checkpoint timeout must be larger than zero");
        Preconditions.checkArgument(minPauseBetweenCheckpoints >= 0L, "minPauseBetweenCheckpoints must be >= 0");
        Preconditions.checkArgument(maxConcurrentCheckpointAttempts >= 1, "maxConcurrentCheckpointAttempts must be >= 1");
        this.job = Preconditions.checkNotNull(job);
        this.baseInterval = baseInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpointAttempts = maxConcurrentCheckpointAttempts;
        this.tasksToTrigger = Preconditions.checkNotNull(tasksToTrigger);
        this.tasksToWaitFor = Preconditions.checkNotNull(tasksToWaitFor);
        this.tasksToCommitTo = Preconditions.checkNotNull(tasksToCommitTo);
        this.pendingCheckpoints = new LinkedHashMap<Long, PendingCheckpoint>();
        this.completedCheckpointStore = Preconditions.checkNotNull(completedCheckpointStore);
        this.recentPendingCheckpoints = new ArrayDeque(16);
        this.userClassLoader = userClassLoader;
        this.checkpointIdCounter = Preconditions.checkNotNull(checkpointIDCounter);
        this.timer = new Timer("Checkpoint Timer", true);
        this.statsTracker = Preconditions.checkNotNull(statsTracker);
        if (recoveryMode == RecoveryMode.STANDALONE) {
            this.shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        CheckpointCoordinator.this.shutdown();
                    }
                    catch (Throwable t) {
                        LOG.error("Error during shutdown of checkpoint coordinator via JVM shutdown hook: " + t.getMessage(), t);
                    }
                }
            });
            try {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Throwable t) {
                LOG.error("Cannot register checkpoint coordinator shutdown hook.", t);
            }
        } else {
            this.shutdownHook = null;
        }
    }

    protected void onShutdown() {
    }

    protected void onCancelCheckpoint(long canceledCheckpointId) {
    }

    protected void onFullyAcknowledgedCheckpoint(CompletedCheckpoint checkpoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.shutdown) {
                    this.shutdown = true;
                    LOG.info("Stopping checkpoint coordinator for job " + this.job);
                    this.periodicScheduling = false;
                    this.triggerRequestQueued = false;
                    this.timer.cancel();
                    if (this.jobStatusListener != null) {
                        this.jobStatusListener.tell(PoisonPill.getInstance());
                        this.jobStatusListener = null;
                    }
                    this.checkpointIdCounter.stop();
                    for (PendingCheckpoint pending : this.pendingCheckpoints.values()) {
                        pending.discard(this.userClassLoader);
                    }
                    this.pendingCheckpoints.clear();
                    this.completedCheckpointStore.discardAllCheckpoints();
                    this.onShutdown();
                }
            }
            finally {
                if (this.shutdownHook != null && this.shutdownHook != Thread.currentThread()) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (Throwable t) {
                        LOG.warn("Error unregistering checkpoint coordinator shutdown hook.", t);
                    }
                }
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean triggerCheckpoint(long timestamp) throws Exception {
        return this.triggerCheckpoint(timestamp, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerCheckpoint(long timestamp, long nextCheckpointId) throws Exception {
        long checkpointID;
        Object ee;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return false;
            }
            if (this.triggerRequestQueued) {
                LOG.warn("Trying to trigger another checkpoint while one was queued already");
                return false;
            }
            if (this.pendingCheckpoints.size() >= this.maxConcurrentCheckpointAttempts) {
                this.triggerRequestQueued = true;
                if (this.currentPeriodicTrigger != null) {
                    this.currentPeriodicTrigger.cancel();
                    this.currentPeriodicTrigger = null;
                }
                return false;
            }
        }
        ExecutionAttemptID[] triggerIDs = new ExecutionAttemptID[this.tasksToTrigger.length];
        for (int i = 0; i < this.tasksToTrigger.length; ++i) {
            Execution ee2 = this.tasksToTrigger[i].getCurrentExecutionAttempt();
            if (ee2 == null || ee2.getState() != ExecutionState.RUNNING) {
                LOG.info("Checkpoint triggering task {} is not being executed at the moment. Aborting checkpoint.", (Object)this.tasksToTrigger[i].getSimpleName());
                return false;
            }
            triggerIDs[i] = ee2.getAttemptId();
        }
        HashMap<ExecutionAttemptID, ExecutionVertex> ackTasks = new HashMap<ExecutionAttemptID, ExecutionVertex>(this.tasksToWaitFor.length);
        for (ExecutionVertex ev : this.tasksToWaitFor) {
            ee = ev.getCurrentExecutionAttempt();
            if (ee == null) {
                LOG.info("Checkpoint acknowledging task {} is not being executed at the moment. Aborting checkpoint.", (Object)ev.getSimpleName());
                return false;
            }
            ackTasks.put(((Execution)ee).getAttemptId(), ev);
        }
        if (nextCheckpointId < 0L) {
            try {
                checkpointID = this.checkpointIdCounter.getAndIncrement();
            }
            catch (Throwable t) {
                int numUnsuccessful = ++this.numUnsuccessfulCheckpointsTriggers;
                LOG.warn("Failed to trigger checkpoint (" + numUnsuccessful + " consecutive failed attempts so far)", t);
                return false;
            }
        } else {
            checkpointID = nextCheckpointId;
        }
        LOG.info("Triggering checkpoint " + checkpointID + " @ " + timestamp);
        final PendingCheckpoint checkpoint = new PendingCheckpoint(this.job, checkpointID, timestamp, ackTasks);
        TimerTask canceller = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = CheckpointCoordinator.this.lock;
                    synchronized (object) {
                        if (!checkpoint.isDiscarded()) {
                            LOG.info("Checkpoint " + checkpointID + " expired before completing.");
                            checkpoint.discard(CheckpointCoordinator.this.userClassLoader);
                            CheckpointCoordinator.this.pendingCheckpoints.remove(checkpointID);
                            CheckpointCoordinator.this.rememberRecentCheckpointId(checkpointID);
                            CheckpointCoordinator.this.onCancelCheckpoint(checkpointID);
                            CheckpointCoordinator.this.triggerQueuedRequests();
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("Exception while handling checkpoint timeout", t);
                }
            }
        };
        try {
            ee = this.lock;
            synchronized (ee) {
                if (this.shutdown) {
                    return false;
                }
                if (this.triggerRequestQueued) {
                    LOG.warn("Trying to trigger another checkpoint while one was queued already");
                    return false;
                }
                if (this.pendingCheckpoints.size() >= this.maxConcurrentCheckpointAttempts) {
                    this.triggerRequestQueued = true;
                    if (this.currentPeriodicTrigger != null) {
                        this.currentPeriodicTrigger.cancel();
                        this.currentPeriodicTrigger = null;
                    }
                    return false;
                }
                this.pendingCheckpoints.put(checkpointID, checkpoint);
                this.timer.schedule(canceller, this.checkpointTimeout);
            }
            for (int i = 0; i < this.tasksToTrigger.length; ++i) {
                ExecutionAttemptID id = triggerIDs[i];
                TriggerCheckpoint message = new TriggerCheckpoint(this.job, id, checkpointID, timestamp);
                this.tasksToTrigger[i].sendMessageToCurrentExecution(message, id);
            }
            this.numUnsuccessfulCheckpointsTriggers = 0;
            return true;
        }
        catch (Throwable t) {
            Object id = this.lock;
            synchronized (id) {
                this.pendingCheckpoints.remove(checkpointID);
            }
            int numUnsuccessful = ++this.numUnsuccessfulCheckpointsTriggers;
            LOG.warn("Failed to trigger checkpoint (" + numUnsuccessful + " consecutive failed attempts so far)", t);
            if (!checkpoint.isDiscarded()) {
                checkpoint.discard(this.userClassLoader);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveDeclineMessage(DeclineCheckpoint message) throws Exception {
        boolean isPendingCheckpoint;
        if (this.shutdown || message == null) {
            return false;
        }
        if (!this.job.equals((Object)message.getJob())) {
            LOG.error("Received DeclineCheckpoint message for wrong job: {}", (Object)message);
            return false;
        }
        long checkpointId = message.getCheckpointId();
        Object completed = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return false;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.get(checkpointId);
            if (checkpoint != null && !checkpoint.isDiscarded()) {
                isPendingCheckpoint = true;
                LOG.info("Discarding checkpoint " + checkpointId + " because of checkpoint decline from task " + (Object)((Object)message.getTaskExecutionId()));
                this.pendingCheckpoints.remove(checkpointId);
                checkpoint.discard(this.userClassLoader);
                this.rememberRecentCheckpointId(checkpointId);
                boolean haveMoreRecentPending = false;
                Iterator<Map.Entry<Long, PendingCheckpoint>> entries = this.pendingCheckpoints.entrySet().iterator();
                while (entries.hasNext()) {
                    PendingCheckpoint p = entries.next().getValue();
                    if (p.isDiscarded() || p.getCheckpointTimestamp() < checkpoint.getCheckpointTimestamp()) continue;
                    haveMoreRecentPending = true;
                    break;
                }
                if (!haveMoreRecentPending && !this.triggerRequestQueued) {
                    LOG.info("Triggering new checkpoint because of discarded checkpoint " + checkpointId);
                    this.triggerCheckpoint(System.currentTimeMillis());
                } else if (!haveMoreRecentPending) {
                    LOG.info("Promoting queued checkpoint request because of discarded checkpoint " + checkpointId);
                    this.triggerQueuedRequests();
                }
            } else {
                if (checkpoint != null) {
                    throw new IllegalStateException("Received message for discarded but non-removed checkpoint " + checkpointId);
                }
                if (this.recentPendingCheckpoints.contains(checkpointId)) {
                    isPendingCheckpoint = true;
                    LOG.info("Received another decline checkpoint message for now expired checkpoint attempt " + checkpointId);
                } else {
                    isPendingCheckpoint = false;
                }
            }
        }
        return isPendingCheckpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveAcknowledgeMessage(AcknowledgeCheckpoint message) throws Exception {
        boolean isPendingCheckpoint;
        if (this.shutdown || message == null) {
            return false;
        }
        if (!this.job.equals((Object)message.getJob())) {
            LOG.error("Received AcknowledgeCheckpoint message for wrong job: {}", (Object)message);
            return false;
        }
        long checkpointId = message.getCheckpointId();
        CompletedCheckpoint completed = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return false;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.get(checkpointId);
            if (checkpoint != null && !checkpoint.isDiscarded()) {
                isPendingCheckpoint = true;
                if (checkpoint.acknowledgeTask(message.getTaskExecutionId(), message.getState(), message.getStateSize())) {
                    if (checkpoint.isFullyAcknowledged()) {
                        completed = checkpoint.toCompletedCheckpoint();
                        this.completedCheckpointStore.addCheckpoint(completed);
                        LOG.info("Completed checkpoint " + checkpointId + " (in " + completed.getDuration() + " ms)");
                        LOG.debug(completed.getStates().toString());
                        this.pendingCheckpoints.remove(checkpointId);
                        this.rememberRecentCheckpointId(checkpointId);
                        this.dropSubsumedCheckpoints(completed.getTimestamp());
                        this.onFullyAcknowledgedCheckpoint(completed);
                        this.triggerQueuedRequests();
                    }
                } else {
                    LOG.error("Received duplicate or invalid acknowledge message for checkpoint " + checkpointId + " , task " + (Object)((Object)message.getTaskExecutionId()));
                }
            } else {
                if (checkpoint != null) {
                    throw new IllegalStateException("Received message for discarded but non-removed checkpoint " + checkpointId);
                }
                if (this.recentPendingCheckpoints.contains(checkpointId)) {
                    isPendingCheckpoint = true;
                    LOG.warn("Received late message for now expired checkpoint attempt " + checkpointId);
                } else {
                    isPendingCheckpoint = false;
                }
            }
        }
        if (completed != null) {
            long timestamp = completed.getTimestamp();
            for (ExecutionVertex ev : this.tasksToCommitTo) {
                Execution ee = ev.getCurrentExecutionAttempt();
                if (ee == null) continue;
                ExecutionAttemptID attemptId = ee.getAttemptId();
                NotifyCheckpointComplete notifyMessage = new NotifyCheckpointComplete(this.job, attemptId, checkpointId, timestamp);
                ev.sendMessageToCurrentExecution(notifyMessage, ee.getAttemptId());
            }
            this.statsTracker.onCompletedCheckpoint(completed);
        }
        return isPendingCheckpoint;
    }

    private void rememberRecentCheckpointId(long id) {
        if (this.recentPendingCheckpoints.size() >= 16) {
            this.recentPendingCheckpoints.removeFirst();
        }
        this.recentPendingCheckpoints.addLast(id);
    }

    private void dropSubsumedCheckpoints(long timestamp) {
        Iterator<Map.Entry<Long, PendingCheckpoint>> entries = this.pendingCheckpoints.entrySet().iterator();
        while (entries.hasNext()) {
            PendingCheckpoint p = entries.next().getValue();
            if (p.getCheckpointTimestamp() >= timestamp) continue;
            this.rememberRecentCheckpointId(p.getCheckpointId());
            p.discard(this.userClassLoader);
            this.onCancelCheckpoint(p.getCheckpointId());
            entries.remove();
        }
    }

    private void triggerQueuedRequests() throws Exception {
        if (this.triggerRequestQueued) {
            this.triggerRequestQueued = false;
            ScheduledTrigger trigger = new ScheduledTrigger();
            if (this.periodicScheduling) {
                if (this.currentPeriodicTrigger != null) {
                    this.currentPeriodicTrigger.cancel();
                }
                this.currentPeriodicTrigger = trigger;
                this.timer.scheduleAtFixedRate((TimerTask)trigger, 0L, this.baseInterval);
            } else {
                this.timer.schedule((TimerTask)trigger, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreLatestCheckpointedState(Map<JobVertexID, ExecutionJobVertex> tasks, boolean errorIfNoCheckpoint, boolean allOrNothingState) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("CheckpointCoordinator is shut down");
            }
            this.completedCheckpointStore.recover();
            CompletedCheckpoint latest = this.completedCheckpointStore.getLatestCheckpoint();
            if (latest == null) {
                if (errorIfNoCheckpoint) {
                    throw new IllegalStateException("No completed checkpoint available");
                }
                return false;
            }
            long recoveryTimestamp = System.currentTimeMillis();
            if (allOrNothingState) {
                ExecutionJobVertex vertex;
                HashMap<ExecutionJobVertex, Integer> stateCounts = new HashMap<ExecutionJobVertex, Integer>();
                for (StateForTask stateForTask : latest.getStates()) {
                    vertex = tasks.get((Object)stateForTask.getOperatorId());
                    Execution exec = vertex.getTaskVertices()[stateForTask.getSubtask()].getCurrentExecutionAttempt();
                    exec.setInitialState(stateForTask.getState(), recoveryTimestamp);
                    Integer count = (Integer)stateCounts.get(vertex);
                    if (count != null) {
                        stateCounts.put(vertex, count + 1);
                        continue;
                    }
                    stateCounts.put(vertex, 1);
                }
                for (Map.Entry entry : stateCounts.entrySet()) {
                    vertex = (ExecutionJobVertex)entry.getKey();
                    if (((Integer)entry.getValue()).intValue() == vertex.getParallelism()) continue;
                    throw new IllegalStateException("The checkpoint contained state only for a subset of tasks for vertex " + vertex);
                }
            } else {
                for (StateForTask state : latest.getStates()) {
                    ExecutionJobVertex executionJobVertex = tasks.get((Object)state.getOperatorId());
                    Execution exec = executionJobVertex.getTaskVertices()[state.getSubtask()].getCurrentExecutionAttempt();
                    exec.setInitialState(state.getState(), recoveryTimestamp);
                }
            }
            return true;
        }
    }

    public int getNumberOfPendingCheckpoints() {
        return this.pendingCheckpoints.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRetainedSuccessfulCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getNumberOfRetainedCheckpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, PendingCheckpoint> getPendingCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<Long, PendingCheckpoint>(this.pendingCheckpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletedCheckpoint> getSuccessfulCheckpoints() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getAllCheckpoints();
        }
    }

    protected long getAndIncrementCheckpointId() {
        try {
            return this.checkpointIdCounter.getAndIncrement();
        }
        catch (Throwable t) {
            int numUnsuccessful = ++this.numUnsuccessfulCheckpointsTriggers;
            LOG.warn("Failed to trigger checkpoint (" + numUnsuccessful + " consecutive failed attempts so far)", t);
            return -1L;
        }
    }

    protected ActorGateway getJobStatusListener() {
        return this.jobStatusListener;
    }

    protected void setJobStatusListener(ActorGateway jobStatusListener) {
        this.jobStatusListener = jobStatusListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            this.stopCheckpointScheduler();
            try {
                this.checkpointIdCounter.start();
            }
            catch (Exception e) {
                String msg = "Failed to start checkpoint ID counter: " + e.getMessage();
                throw new RuntimeException(msg, e);
            }
            this.periodicScheduling = true;
            this.currentPeriodicTrigger = new ScheduledTrigger();
            this.timer.scheduleAtFixedRate((TimerTask)this.currentPeriodicTrigger, this.baseInterval, this.baseInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            this.triggerRequestQueued = false;
            this.periodicScheduling = false;
            if (this.currentPeriodicTrigger != null) {
                this.currentPeriodicTrigger.cancel();
                this.currentPeriodicTrigger = null;
            }
            for (PendingCheckpoint p : this.pendingCheckpoints.values()) {
                p.discard(this.userClassLoader);
            }
            this.pendingCheckpoints.clear();
            this.numUnsuccessfulCheckpointsTriggers = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActorGateway createActivatorDeactivator(ActorSystem actorSystem, UUID leaderSessionID) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            if (this.jobStatusListener == null) {
                Props props = Props.create(CheckpointCoordinatorDeActivator.class, (Object[])new Object[]{this, leaderSessionID});
                this.jobStatusListener = new AkkaActorGateway(actorSystem.actorOf(props), leaderSessionID);
            }
            return this.jobStatusListener;
        }
    }

    private class ScheduledTrigger
    extends TimerTask {
        private ScheduledTrigger() {
        }

        @Override
        public void run() {
            try {
                CheckpointCoordinator.this.triggerCheckpoint(System.currentTimeMillis());
            }
            catch (Exception e) {
                LOG.error("Exception while triggering checkpoint", (Throwable)e);
            }
        }
    }
}

