/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class IntermediateDataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IntermediateDataSetID id;
    private final JobVertex producer;
    private final List<JobEdge> consumers = new ArrayList<JobEdge>();
    private final ResultPartitionType resultType;
    private boolean eagerlyDeployConsumers;

    public IntermediateDataSet(JobVertex producer) {
        this(new IntermediateDataSetID(), producer);
    }

    public IntermediateDataSet(IntermediateDataSetID id, JobVertex producer) {
        this(id, ResultPartitionType.PIPELINED, producer);
    }

    public IntermediateDataSet(IntermediateDataSetID id, ResultPartitionType resultType, JobVertex producer) {
        this.id = Preconditions.checkNotNull(id);
        this.producer = Preconditions.checkNotNull(producer);
        this.resultType = Preconditions.checkNotNull(resultType);
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public JobVertex getProducer() {
        return this.producer;
    }

    public List<JobEdge> getConsumers() {
        return this.consumers;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    public void setEagerlyDeployConsumers(boolean eagerlyDeployConsumers) {
        this.eagerlyDeployConsumers = eagerlyDeployConsumers;
    }

    public boolean getEagerlyDeployConsumers() {
        return this.eagerlyDeployConsumers;
    }

    public void addConsumer(JobEdge edge) {
        this.consumers.add(edge);
    }

    public String toString() {
        return "Intermediate Data Set (" + (Object)((Object)this.id) + ")";
    }
}

