/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.Patterns$;
import akka.pattern.package$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.messages.TaskManagerMessages$NotifyWhenRegisteredAtAnyJobManager$;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster$;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\reh!B\u0001\u0003\u0003\u0003i!\u0001\u0005$mS:\\W*\u001b8j\u00072,8\u000f^3s\u0015\t\u0019A!A\u0006nS:L7\r\\;ti\u0016\u0014(BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0010Y\u0016\fG-\u001a:sKR\u0014\u0018.\u001a<bY&\u00111\u0004\u0007\u0002\u0018\u0019\u0016\fG-\u001a:SKR\u0014\u0018.\u001a<bY2K7\u000f^3oKJD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0012kN,'oQ8oM&<WO]1uS>tW#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t2\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002%C\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0013kN,'oQ8oM&<WO]1uS>t\u0007\u0005\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0001*\u0003Q)8/Z*j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[V\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCFA\u0004C_>dW-\u00198\t\u0011E\u0002!\u0011!Q\u0001\n)\nQ#^:f'&tw\r\\3BGR|'oU=ti\u0016l\u0007\u0005C\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0004k]B\u0004C\u0001\u001c\u0001\u001b\u0005\u0011\u0001\"B\u000f3\u0001\u0004y\u0002\"\u0002\u00153\u0001\u0004Q\u0003b\u0002\u001e\u0001\u0005\u0004%\tbO\u0001\u0004\u0019>;U#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}R\u0011!B:mMRR\u0017BA!?\u0005\u0019aunZ4fe\"11\t\u0001Q\u0001\nq\nA\u0001T(HA!9Q\t\u0001b\u0001\n\u00031\u0015\u0001\u00035pgRt\u0017-\\3\u0016\u0003\u001d\u0003\"a\u0004%\n\u0005%\u0003\"AB*ue&tw\r\u0003\u0004L\u0001\u0001\u0006IaR\u0001\nQ>\u001cHO\\1nK\u0002BqA\t\u0001C\u0002\u0013\u0005a\u0004\u0003\u0004O\u0001\u0001\u0006IaH\u0001\u000fG>tg-[4ve\u0006$\u0018n\u001c8!\u0011\u001d\u0001\u0006\u00011A\u0005\u0002E\u000bQ\u0002\\3bI\u0016\u0014x)\u0019;fo\u0006LX#\u0001*\u0011\u0007M3\u0006,D\u0001U\u0015\t)F&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0016+\u0003\u000fA\u0013x.\\5tKB\u0011\u0011\fX\u0007\u00025*\u00111\fB\u0001\tS:\u001cH/\u00198dK&\u0011QL\u0017\u0002\r\u0003\u000e$xN]$bi\u0016<\u0018-\u001f\u0005\b?\u0002\u0001\r\u0011\"\u0001a\u0003EaW-\u00193fe\u001e\u000bG/Z<bs~#S-\u001d\u000b\u0003C\u0012\u0004\"a\u000b2\n\u0005\rd#\u0001B+oSRDq!\u001a0\u0002\u0002\u0003\u0007!+A\u0002yIEBaa\u001a\u0001!B\u0013\u0011\u0016A\u00047fC\u0012,'oR1uK^\f\u0017\u0010\t\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u0003-aW-\u00193fe&sG-\u001a=\u0016\u0003-\u00042a\u0015,m!\tYS.\u0003\u0002oY\t\u0019\u0011J\u001c;\t\u000fA\u0004\u0001\u0019!C\u0001c\u0006yA.Z1eKJLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002be\"9Qm\\A\u0001\u0002\u0004Y\u0007B\u0002;\u0001A\u0003&1.\u0001\u0007mK\u0006$WM]%oI\u0016D\b\u0005C\u0004w\u0001\t\u0007I\u0011A<\u0002\u0015\u0019,H/\u001e:f\u0019>\u001c7.F\u0001\u000f\u0011\u0019I\b\u0001)A\u0005\u001d\u0005Ya-\u001e;ve\u0016dunY6!\u0011\u001dY\bA1A\u0005\u0004q\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003u\u0004\"a\u0015@\n\u0005}$&\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\"9\u00111\u0001\u0001!\u0002\u0013i\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA!I\u0011q\u0001\u0001C\u0002\u0013\r\u0011\u0011B\u0001\bi&lWm\\;u+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002V\u0001\tIV\u0014\u0018\r^5p]&!\u0011QCA\b\u000591\u0015N\\5uK\u0012+(/\u0019;j_:D\u0001\"!\u0007\u0001A\u0003%\u00111B\u0001\ti&lWm\\;uA!I\u0011Q\u0004\u0001C\u0002\u0013\u0005\u0011qD\u0001\re\u0016\u001cwN^3ss6{G-Z\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0011A\u00036pE6\fg.Y4fe&!\u00111FA\u0013\u00051\u0011VmY8wKJLXj\u001c3f\u0011!\ty\u0003\u0001Q\u0001\n\u0005\u0005\u0012!\u0004:fG>4XM]=N_\u0012,\u0007\u0005C\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026\u0005qa.^7K_\nl\u0015M\\1hKJ\u001cX#\u00017\t\u000f\u0005e\u0002\u0001)A\u0005Y\u0006ya.^7K_\nl\u0015M\\1hKJ\u001c\b\u0005C\u0005\u0002>\u0001\u0011\r\u0011\"\u0001\u00026\u0005ya.^7UCN\\W*\u00198bO\u0016\u00148\u000fC\u0004\u0002B\u0001\u0001\u000b\u0011\u00027\u0002!9,X\u000eV1tW6\u000bg.Y4feN\u0004\u0003\"CA#\u0001\u0001\u0007I\u0011AA$\u0003YQwNY'b]\u0006<WM]!di>\u00148+_:uK6\u001cXCAA%!\u0015Y\u00131JA(\u0013\r\ti\u0005\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005E\u0013\u0011MA4\u001d\u0011\t\u0019&!\u0018\u000f\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\r\u0003\u0019a$o\\8u}%\tQ&C\u0002\u0002`1\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0005\u0015$aA*fc*\u0019\u0011q\f\u0017\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005)\u0011m\u0019;pe*\u0011\u0011\u0011O\u0001\u0005C.\\\u0017-\u0003\u0003\u0002v\u0005-$aC!di>\u00148+_:uK6D\u0011\"!\u001f\u0001\u0001\u0004%\t!a\u001f\u00025)|'-T1oC\u001e,'/Q2u_J\u001c\u0016p\u001d;f[N|F%Z9\u0015\u0007\u0005\fi\bC\u0005f\u0003o\n\t\u00111\u0001\u0002J!A\u0011\u0011\u0011\u0001!B\u0013\tI%A\fk_\nl\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7tA!I\u0011Q\u0011\u0001A\u0002\u0013\u0005\u0011qQ\u0001\u0011U>\u0014W*\u00198bO\u0016\u0014\u0018i\u0019;peN,\"!!#\u0011\u000b-\nY%a#\u0011\r\u0005E\u0013\u0011MAG!\u0011\tI'a$\n\t\u0005E\u00151\u000e\u0002\t\u0003\u000e$xN\u001d*fM\"I\u0011Q\u0013\u0001A\u0002\u0013\u0005\u0011qS\u0001\u0015U>\u0014W*\u00198bO\u0016\u0014\u0018i\u0019;peN|F%Z9\u0015\u0007\u0005\fI\nC\u0005f\u0003'\u000b\t\u00111\u0001\u0002\n\"A\u0011Q\u0014\u0001!B\u0013\tI)A\tk_\nl\u0015M\\1hKJ\f5\r^8sg\u0002B\u0011\"!)\u0001\u0001\u0004%\t!a)\u0002\u0015],'-T8oSR|'/\u0006\u0002\u0002&B)1&a\u0013\u0002(B!\u0011\u0011VAX\u001b\t\tYKC\u0002\u0002.\u0012\t!b^3c[>t\u0017\u000e^8s\u0013\u0011\t\t,a+\u0003\u0015]+'-T8oSR|'\u000fC\u0005\u00026\u0002\u0001\r\u0011\"\u0001\u00028\u0006qq/\u001a2N_:LGo\u001c:`I\u0015\fHcA1\u0002:\"IQ-a-\u0002\u0002\u0003\u0007\u0011Q\u0015\u0005\t\u0003{\u0003\u0001\u0015)\u0003\u0002&\u0006Yq/\u001a2N_:LGo\u001c:!\u0011%\t\t\r\u0001a\u0001\n\u0003\t9%A\fuCN\\W*\u00198bO\u0016\u0014\u0018i\u0019;peNK8\u000f^3ng\"I\u0011Q\u0019\u0001A\u0002\u0013\u0005\u0011qY\u0001\u001ci\u0006\u001c8.T1oC\u001e,'/Q2u_J\u001c\u0016p\u001d;f[N|F%Z9\u0015\u0007\u0005\fI\rC\u0005f\u0003\u0007\f\t\u00111\u0001\u0002J!A\u0011Q\u001a\u0001!B\u0013\tI%\u0001\ruCN\\W*\u00198bO\u0016\u0014\u0018i\u0019;peNK8\u000f^3ng\u0002B\u0011\"!5\u0001\u0001\u0004%\t!a\"\u0002#Q\f7o['b]\u0006<WM]!di>\u00148\u000fC\u0005\u0002V\u0002\u0001\r\u0011\"\u0001\u0002X\u0006)B/Y:l\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:`I\u0015\fHcA1\u0002Z\"IQ-a5\u0002\u0002\u0003\u0007\u0011\u0011\u0012\u0005\t\u0003;\u0004\u0001\u0015)\u0003\u0002\n\u0006\u0011B/Y:l\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:!\u0011%\t\t\u000f\u0001a\u0001\n#\t\u0019/\u0001\fmK\u0006$WM\u001d*fiJLWM^1m'\u0016\u0014h/[2f+\t\t)\u000fE\u0003,\u0003\u0017\n9\u000fE\u0002\u0018\u0003SL1!a;\u0019\u0005YaU-\u00193feJ+GO]5fm\u0006d7+\u001a:wS\u000e,\u0007\"CAx\u0001\u0001\u0007I\u0011CAy\u0003iaW-\u00193feJ+GO]5fm\u0006d7+\u001a:wS\u000e,w\fJ3r)\r\t\u00171\u001f\u0005\nK\u00065\u0018\u0011!a\u0001\u0003KD\u0001\"a>\u0001A\u0003&\u0011Q]\u0001\u0018Y\u0016\fG-\u001a:SKR\u0014\u0018.\u001a<bYN+'O^5dK\u0002B\u0001\"a?\u0001\u0001\u0004%I!K\u0001\nSN\u0014VO\u001c8j]\u001eD\u0011\"a@\u0001\u0001\u0004%IA!\u0001\u0002\u001b%\u001c(+\u001e8oS:<w\fJ3r)\r\t'1\u0001\u0005\tK\u0006u\u0018\u0011!a\u0001U!9!q\u0001\u0001!B\u0013Q\u0013AC5t%Vtg.\u001b8hA!9!1\u0002\u0001\u0007\u0002\t5\u0011!F4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ;sCRLwN\u001c\u000b\u0004?\t=\u0001BB\u000f\u0003\n\u0001\u0007q\u0004C\u0004\u0003\u0014\u00011\tA!\u0006\u0002\u001fM$\u0018M\u001d;K_\nl\u0015M\\1hKJ$b!!$\u0003\u0018\tm\u0001b\u0002B\r\u0005#\u0001\r\u0001\\\u0001\u0006S:$W\r\u001f\u0005\t\u0005;\u0011\t\u00021\u0001\u0002h\u000511/_:uK6DqA!\t\u0001\r\u0003\u0011\u0019#\u0001\tti\u0006\u0014H\u000fV1tW6\u000bg.Y4feR1\u0011Q\u0012B\u0013\u0005OAqA!\u0007\u0003 \u0001\u0007A\u000e\u0003\u0005\u0003\u001e\t}\u0001\u0019AA4\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003k\tacZ3u\u001dVl'-\u001a:PM*{'-T1oC\u001e,'o\u001d\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0003Q9W\r\u001e&pE6\u000bg.Y4feN\f5OS1wCV\u0011!1\u0007\t\u0007\u0005k\u0011Y$!$\u000e\u0005\t]\"b\u0001B\u001d%\u0005!Q\u000f^5m\u0013\u0011\u0011iDa\u000e\u0003\t1K7\u000f\u001e\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0003=9W\r\u001e+bg.l\u0015M\\1hKJ\u001cXCAAF\u0011\u001d\u00119\u0005\u0001C\u0001\u0005c\tQcZ3u)\u0006\u001c8.T1oC\u001e,'o]!t\u0015\u00064\u0018\rC\u0004\u0003L\u0001!\tA!\u0014\u0002-\u001d,G\u000fT3bI\u0016\u0014x)\u0019;fo\u0006Lh)\u001e;ve\u0016,\"Aa\u0014\u0011\tM\u0013\t\u0006W\u0005\u0004\u0005'\"&A\u0002$viV\u0014X\rC\u0004\u0003X\u0001!\tA!\u0017\u0002!\u001d,G\u000fT3bI\u0016\u0014x)\u0019;fo\u0006LHc\u0001-\u0003\\!A\u0011q\u0001B+\u0001\u0004\tY\u0001C\u0004\u0003`\u0001!\tA!\u0019\u0002)\u001d,G\u000fT3bI\u0016\u0014\u0018J\u001c3fq\u001a+H/\u001e:f+\t\u0011\u0019\u0007\u0005\u0003T\u0005#b\u0007b\u0002B4\u0001\u0011\u0005!\u0011N\u0001\u000fO\u0016$H*Z1eKJLe\u000eZ3y)\ra'1\u000e\u0005\t\u0003\u000f\u0011)\u00071\u0001\u0002\f!9!q\u000e\u0001\u0005\u0002\tE\u0014aF4fi*{'-T1oC\u001e,'/Q6lC\u000e{gNZ5h)\u0011\u0011\u0019Ha\"\u0011\t\tU$1Q\u0007\u0003\u0005oRAA!\u001f\u0003|\u000511m\u001c8gS\u001eTAA! \u0003\u0000\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0003\u0002\u0006\u00191m\\7\n\t\t\u0015%q\u000f\u0002\u0007\u0007>tg-[4\t\u000f\te!Q\u000ea\u0001Y\"9!1\u0012\u0001\u0005\u0002\t5\u0015\u0001G4fiR\u000b7o['b]\u0006<WM]!lW\u0006\u001cuN\u001c4jOR!!1\u000fBH\u0011\u001d\u0011IB!#A\u00021DqAa%\u0001\t\u0003\u0011)*\u0001\ntKR$UMZ1vYR\u001c\u0015nQ8oM&<GcA1\u0003\u0018\"9!\u0011\u0010BI\u0001\u0004y\u0002b\u0002BN\u0001\u0011\u0005!QT\u0001\u001bgR\f'\u000f\u001e&pE6\u000bg.Y4fe\u0006\u001bGo\u001c:TsN$X-\u001c\u000b\u0005\u0003O\u0012y\nC\u0004\u0003\u001a\te\u0005\u0019\u00017\t\u000f\t\r\u0006\u0001\"\u0001\u0003&\u0006Y2\u000f^1siR\u000b7o['b]\u0006<WM]!di>\u00148+_:uK6$B!a\u001a\u0003(\"9!\u0011\u0004BQ\u0001\u0004a\u0007b\u0002BV\u0001\u0011\u0005!QV\u0001\u001agR\f'\u000f\u001e&pE\u000ec\u0017.\u001a8u\u0003\u000e$xN]*zgR,W\u000e\u0006\u0003\u0002h\t=\u0006\u0002\u0003BY\u0005S\u0003\rAa-\u0002\u000b)|'-\u0013#\u0011\t\tU&qX\u0007\u0003\u0005oSAA!/\u0003<\u000611m\\7n_:T1A!0\u0007\u0003\r\t\u0007/[\u0005\u0005\u0005\u0003\u00149LA\u0003K_\nLE\tC\u0004\u0003F\u0002!\tAa2\u0002\u000bM$\u0018M\u001d;\u0015\u0003\u0005DqA!2\u0001\t\u0003\u0011Y\rF\u0002b\u0005\u001bDqAa4\u0003J\u0002\u0007!&\u0001\u0010xC&$hi\u001c:UCN\\W*\u00198bO\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]\"9!1\u001b\u0001\u0005\u0002\tU\u0017AD:uCJ$x+\u001a2TKJ4XM\u001d\u000b\t\u0003K\u00139N!7\u0003^\"9!\u0011\u0010Bi\u0001\u0004y\u0002\u0002\u0003Bn\u0005#\u0004\r!a\u001a\u0002\u0017\u0005\u001cGo\u001c:TsN$X-\u001c\u0005\t\u0005?\u0014\t\u000e1\u0001\u0003b\u0006\t\"n\u001c2NC:\fw-\u001a:BW.\fWK\u0015'\u0011\t\t\r(\u0011\u001e\b\u0004W\t\u0015\u0018b\u0001BtY\u00051\u0001K]3eK\u001aL1!\u0013Bv\u0015\r\u00119\u000f\f\u0005\b\u0005_\u0004A\u0011\u0001Bd\u0003\u0011\u0019Ho\u001c9\t\u000f\tM\b\u0001\"\u0005\u0003H\u0006A1\u000f[;uI><h\u000eC\u0004\u0003x\u0002!\tAa2\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007B\u0002B~\u0001\u0011\u0005\u0011&A\u0004sk:t\u0017N\\4\t\u000f\t}\b\u0001\"\u0001\u0003H\u0006\ts/Y5u\r>\u0014H+Y:l\u001b\u0006t\u0017mZ3sgR{')\u001a*fO&\u001cH/\u001a:fI\"2!Q`B\u0002\u0007C\u0001RaKB\u0003\u0007\u0013I1aa\u0002-\u0005\u0019!\bN]8xgB!11BB\u0007\u0019\u0001!qaa\u0004\u0001\u0005\u0004\u0019\tBA\u0001U#\u0011\u0019\u0019b!\u0007\u0011\u0007-\u001a)\"C\u0002\u0004\u00181\u0012qAT8uQ&tw\r\u0005\u0003\u0004\u001c\ruabA\u0016\u0002^%!1qDA3\u0005%!\u0006N]8xC\ndWm\t\u0002\u0004$A!\u0011\u0011KB\u0013\u0013\u0011\u00199#!\u001a\u0003)%sG/\u001a:skB$X\rZ#yG\u0016\u0004H/[8oQ\u0019\u0011ipa\u000b\u00042A)1f!\u0002\u0004.A!11BB\u0018\t\u001d\u0019y\u0001\u0001b\u0001\u0007#\u0019#aa\r\u0011\t\rU2Q\b\b\u0005\u0007o\u0019YD\u0004\u0003\u0002T\re\u0012BA+-\u0013\r\ty\u0006V\u0005\u0005\u0007\u007f\u0019\tE\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]*\u0019\u0011q\f+\t\u000f\t}\b\u0001\"\u0001\u0004FQ\u0019\u0011ma\u0012\t\u0011\u0005\u001d11\ta\u0001\u0003\u0017Acaa\u0011\u0004L\r\u0005\u0002#B\u0016\u0004\u0006\r5\u0003\u0003BB\u0006\u0007\u001f\"qaa\u0004\u0001\u0005\u0004\u0019\t\u0002\u000b\u0004\u0004D\rM3\u0011\u0007\t\u0006W\r\u00151Q\u000b\t\u0005\u0007\u0017\u00199\u0006B\u0004\u0004\u0010\u0001\u0011\ra!\u0005\t\u000f\rm\u0003\u0001\"\u0001\u0004^\u0005\u00012/\u001e2nSRTuNY!oI^\u000b\u0017\u000e\u001e\u000b\u0007\u0007?\u001a)g!\u001e\u0011\t\tU6\u0011M\u0005\u0005\u0007G\u00129L\u0001\nK_\n,\u00050Z2vi&|gNU3tk2$\b\u0002CB4\u00073\u0002\ra!\u001b\u0002\u0011)|'m\u0012:ba\"\u0004Baa\u001b\u0004r5\u00111Q\u000e\u0006\u0004\u0007_\"\u0011\u0001\u00036pE\u001e\u0014\u0018\r\u001d5\n\t\rM4Q\u000e\u0002\t\u0015>\u0014wI]1qQ\"91qOB-\u0001\u0004Q\u0013\u0001\u00049sS:$X\u000b\u001d3bi\u0016\u001c\bFBB-\u0007w\u001a\t\tE\u0003,\u0007\u000b\u0019i\b\u0005\u0003\u0004\f\r}DaBB\b\u0001\t\u00071\u0011C\u0012\u0003\u0007\u0007\u0003Ba!\"\u0004\f6\u00111q\u0011\u0006\u0004\u0007\u0013#\u0011AB2mS\u0016tG/\u0003\u0003\u0004\u000e\u000e\u001d%!\u0006&pE\u0016CXmY;uS>tW\t_2faRLwN\u001c\u0005\b\u00077\u0002A\u0011ABI)!\u0019yfa%\u0004\u0016\u000e]\u0005\u0002CB4\u0007\u001f\u0003\ra!\u001b\t\u000f\r]4q\u0012a\u0001U!A\u0011qABH\u0001\u0004\tY\u0001C\u0004\u0004\\\u0001!\taa'\u0015\u0015\r}3QTBP\u0007C\u001b\u0019\u000b\u0003\u0005\u0004h\re\u0005\u0019AB5\u0011\u001d\u00199h!'A\u0002)B\u0001\"a\u0002\u0004\u001a\u0002\u0007\u00111\u0002\u0005\t\u0003C\u001cI\n1\u0001\u0002h\"21\u0011TBT\u0007\u0003\u0003RaKB\u0003\u0007S\u0003Baa\u0003\u0004,\u001291q\u0002\u0001C\u0002\rE\u0001bBBX\u0001\u0011\u00051\u0011W\u0001\u0012gV\u0014W.\u001b;K_\n$U\r^1dQ\u0016$G\u0003BBZ\u0007s\u0003BA!.\u00046&!1q\u0017B\\\u0005MQuNY*vE6L7o]5p]J+7/\u001e7u\u0011!\u00199g!,A\u0002\r%\u0004FBBW\u0007{\u001b\t\tE\u0003,\u0007\u000b\u0019y\f\u0005\u0003\u0004\f\r\u0005GaBB\b\u0001\t\u00071\u0011\u0003\u0005\b\u0007\u000b\u0004A\u0011ABd\u0003q\u0019\b.\u001e;e_^t'j\u001c2DY&,g\u000e^!di>\u00148+_:uK6$2!YBe\u0011!\u0011Yna1A\u0002\u0005\u001d\u0004bBBg\u0001\u0011E1qZ\u0001\u001dGJ,\u0017\r^3MK\u0006$WM\u001d*fiJLWM^1m'\u0016\u0014h/[2f)\t\t9\u000fC\u0004\u0004T\u0002!\tBa2\u0002\u0017\rdW-\u0019:MK\u0006$WM\u001d\u0005\b\u0007/\u0004A\u0011IBm\u0003Mqw\u000e^5gs2+\u0017\rZ3s\u0003\u0012$'/Z:t)\u0015\t71\\Bp\u0011!\u0019in!6A\u0002\t\u0005\u0018aB1eIJ,7o\u001d\u0005\t\u0007C\u001c)\u000e1\u0001\u0004d\u0006yA.Z1eKJ\u001cVm]:j_:LE\t\u0005\u0003\u00036\r\u0015\u0018\u0002BBt\u0005o\u0011A!V+J\t\"911\u001e\u0001\u0005B\r5\u0018a\u00035b]\u0012dW-\u0012:s_J$2!YBx\u0011!\u0019\tp!;A\u0002\rM\u0018!C3yG\u0016\u0004H/[8o!\u0011\t\tf!>\n\t\r]\u0018Q\r\u0002\n\u000bb\u001cW\r\u001d;j_:\u0004")
public abstract class FlinkMiniCluster
implements LeaderRetrievalListener {
    private final Configuration userConfiguration;
    private final boolean useSingleActorSystem;
    private final Logger LOG;
    private final String hostname;
    private final Configuration configuration;
    private Promise<ActorGateway> leaderGateway;
    private Promise<Object> leaderIndex;
    private final Object futureLock;
    private final ExecutionContextExecutor executionContext;
    private final FiniteDuration timeout;
    private final RecoveryMode recoveryMode;
    private final int numJobManagers;
    private final int numTaskManagers;
    private Option<Seq<ActorSystem>> jobManagerActorSystems;
    private Option<Seq<ActorRef>> jobManagerActors;
    private Option<WebMonitor> webMonitor;
    private Option<Seq<ActorSystem>> taskManagerActorSystems;
    private Option<Seq<ActorRef>> taskManagerActors;
    private Option<LeaderRetrievalService> leaderRetrievalService;
    private boolean isRunning;

    public Configuration userConfiguration() {
        return this.userConfiguration;
    }

    public boolean useSingleActorSystem() {
        return this.useSingleActorSystem;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public String hostname() {
        return this.hostname;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Promise<ActorGateway> leaderGateway() {
        return this.leaderGateway;
    }

    public void leaderGateway_$eq(Promise<ActorGateway> x$1) {
        this.leaderGateway = x$1;
    }

    public Promise<Object> leaderIndex() {
        return this.leaderIndex;
    }

    public void leaderIndex_$eq(Promise<Object> x$1) {
        this.leaderIndex = x$1;
    }

    public Object futureLock() {
        return this.futureLock;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public RecoveryMode recoveryMode() {
        return this.recoveryMode;
    }

    public int numJobManagers() {
        return this.numJobManagers;
    }

    public int numTaskManagers() {
        return this.numTaskManagers;
    }

    public Option<Seq<ActorSystem>> jobManagerActorSystems() {
        return this.jobManagerActorSystems;
    }

    public void jobManagerActorSystems_$eq(Option<Seq<ActorSystem>> x$1) {
        this.jobManagerActorSystems = x$1;
    }

    public Option<Seq<ActorRef>> jobManagerActors() {
        return this.jobManagerActors;
    }

    public void jobManagerActors_$eq(Option<Seq<ActorRef>> x$1) {
        this.jobManagerActors = x$1;
    }

    public Option<WebMonitor> webMonitor() {
        return this.webMonitor;
    }

    public void webMonitor_$eq(Option<WebMonitor> x$1) {
        this.webMonitor = x$1;
    }

    public Option<Seq<ActorSystem>> taskManagerActorSystems() {
        return this.taskManagerActorSystems;
    }

    public void taskManagerActorSystems_$eq(Option<Seq<ActorSystem>> x$1) {
        this.taskManagerActorSystems = x$1;
    }

    public Option<Seq<ActorRef>> taskManagerActors() {
        return this.taskManagerActors;
    }

    public void taskManagerActors_$eq(Option<Seq<ActorRef>> x$1) {
        this.taskManagerActors = x$1;
    }

    public Option<LeaderRetrievalService> leaderRetrievalService() {
        return this.leaderRetrievalService;
    }

    public void leaderRetrievalService_$eq(Option<LeaderRetrievalService> x$1) {
        this.leaderRetrievalService = x$1;
    }

    private boolean isRunning() {
        return this.isRunning;
    }

    private void isRunning_$eq(boolean x$1) {
        this.isRunning = x$1;
    }

    public abstract Configuration generateConfiguration(Configuration var1);

    public abstract ActorRef startJobManager(int var1, ActorSystem var2);

    public abstract ActorRef startTaskManager(int var1, ActorSystem var2);

    public int getNumberOfJobManagers() {
        RecoveryMode recoveryMode = this.recoveryMode();
        RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
        return !(recoveryMode != null ? !((Object)((Object)recoveryMode)).equals((Object)recoveryMode2) : recoveryMode2 != null) ? 1 : this.configuration().getInteger("local.number-jobmanager", 1);
    }

    public List<ActorRef> getJobManagersAsJava() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.jobManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        })).asJava();
    }

    public Seq<ActorRef> getTaskManagers() {
        return (Seq)this.taskManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public List<ActorRef> getTaskManagersAsJava() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.taskManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        })).asJava();
    }

    public Future<ActorGateway> getLeaderGatewayFuture() {
        return this.leaderGateway().future();
    }

    public ActorGateway getLeaderGateway(FiniteDuration timeout) {
        Future<ActorGateway> jmFuture = this.getLeaderGatewayFuture();
        return (ActorGateway)Await$.MODULE$.result(jmFuture, (Duration)timeout);
    }

    public Future<Object> getLeaderIndexFuture() {
        return this.leaderIndex().future();
    }

    public int getLeaderIndex(FiniteDuration timeout) {
        Future<Object> indexFuture = this.getLeaderIndexFuture();
        return BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result(indexFuture, (Duration)timeout));
    }

    public Config getJobManagerAkkaConfig(int index) {
        Config config;
        if (this.useSingleActorSystem()) {
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)None$.MODULE$);
        } else {
            int port = this.configuration().getInteger("jobmanager.rpc.port", 6123);
            int resolvedPort = port != 0 ? port + index : port;
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
        }
        return config;
    }

    public Config getTaskManagerAkkaConfig(int index) {
        int port = this.configuration().getInteger("taskmanager.rpc.port", 0);
        int resolvedPort = port != 0 ? port + index : port;
        return AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
    }

    public void setDefaultCiConfig(Configuration config) {
        if (scala.sys.package$.MODULE$.env().contains((Object)"CI")) {
            if (config.getString("akka.ask.timeout", null) == null) {
                Duration duration = Duration$.MODULE$.apply(ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT).$times(10.0);
                config.setString("akka.ask.timeout", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)duration.toSeconds())})));
                this.LOG().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Akka ask timeout set to ", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)duration.toSeconds())})));
            }
        }
    }

    public ActorSystem startJobManagerActorSystem(int index) {
        Config config = this.getJobManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    public ActorSystem startTaskManagerActorSystem(int index) {
        Config config = this.getTaskManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActorSystem startJobClientActorSystem(JobID jobID) {
        ActorSystem actorSystem;
        if (!this.useSingleActorSystem()) {
            actorSystem = JobClient.startJobClientActorSystem(this.configuration());
            return actorSystem;
        }
        Option<Seq<ActorSystem>> option = this.jobManagerActorSystems();
        if (option instanceof Some) {
            ActorSystem actorSystem2;
            Some some = (Some)option;
            Seq jmActorSystems = (Seq)some.x();
            actorSystem = actorSystem2 = (ActorSystem)jmActorSystems.apply(0);
            return actorSystem;
        }
        None$ none$ = None$.MODULE$;
        Option<Seq<ActorSystem>> option2 = option;
        if (none$ == null) {
            if (option2 == null) throw new JobExecutionException(jobID, "The FlinkMiniCluster has not been started yet.");
            throw new MatchError(option);
        }
        if (!none$.equals(option2)) throw new MatchError(option);
        throw new JobExecutionException(jobID, "The FlinkMiniCluster has not been started yet.");
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean waitForTaskManagerRegistration) {
        ObjectRef singleActorSystem$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        this.LOG().info("Starting FlinkMiniCluster.");
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numJobManagers()).map((Function1)new $anonfun$1(this, singleActorSystem$lzy, bitmap$0), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq jmActorSystems = (IndexedSeq)tuple2._1();
            IndexedSeq jmActors = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jmActorSystems, (Object)jmActors);
            IndexedSeq jmActorSystems2 = (IndexedSeq)tuple23._1();
            IndexedSeq jmActors2 = (IndexedSeq)tuple23._2();
            this.jobManagerActorSystems_$eq((Option<Seq<ActorSystem>>)new Some((Object)jmActorSystems2));
            this.jobManagerActors_$eq((Option<Seq<ActorRef>>)new Some((Object)jmActors2));
            LeaderRetrievalService lrs = this.createLeaderRetrievalService();
            this.leaderRetrievalService_$eq((Option<LeaderRetrievalService>)new Some((Object)lrs));
            lrs.start(this);
            Tuple2 tuple24 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numTaskManagers()).map((Function1)new $anonfun$2(this, jmActorSystems2), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
            if (tuple24 != null) {
                Tuple2 tuple25;
                IndexedSeq tmActorSystems = (IndexedSeq)tuple24._1();
                IndexedSeq tmActors = (IndexedSeq)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)tmActorSystems, (Object)tmActors);
                IndexedSeq tmActorSystems2 = (IndexedSeq)tuple26._1();
                IndexedSeq tmActors2 = (IndexedSeq)tuple26._2();
                this.taskManagerActorSystems_$eq((Option<Seq<ActorSystem>>)new Some((Object)tmActorSystems2));
                this.taskManagerActors_$eq((Option<Seq<ActorRef>>)new Some((Object)tmActors2));
                String jobManagerAkkaURL = AkkaUtils$.MODULE$.getAkkaURL((ActorSystem)jmActorSystems2.apply(0), (ActorRef)jmActors2.apply(0));
                this.webMonitor_$eq(this.startWebServer(this.configuration(), (ActorSystem)jmActorSystems2.apply(0), jobManagerAkkaURL));
                if (waitForTaskManagerRegistration) {
                    this.waitForTaskManagersToBeRegistered();
                }
                this.isRunning_$eq(true);
                return;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<WebMonitor> startWebServer(Configuration config, ActorSystem actorSystem, String jobManagerAkkaURL) {
        None$ none$;
        if (config.getBoolean("local.start-webserver", false) && config.getInteger("jobmanager.web.port", 0) >= 0) {
            StandaloneLeaderRetrievalService leaderRetrievalService = new StandaloneLeaderRetrievalService(jobManagerAkkaURL);
            this.LOG().info("Starting JobManger web frontend");
            Option webServer = Option$.MODULE$.apply((Object)WebMonitorUtils.startWebRuntimeMonitor(config, leaderRetrievalService, actorSystem));
            webServer.foreach((Function1)new Serializable(this, jobManagerAkkaURL){
                public static final long serialVersionUID = 0L;
                private final String jobManagerAkkaURL$1;

                public final void apply(WebMonitor x$3) {
                    x$3.start(this.jobManagerAkkaURL$1);
                }
                {
                    this.jobManagerAkkaURL$1 = jobManagerAkkaURL$1;
                }
            });
            none$ = webServer;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void stop() {
        this.LOG().info("Stopping FlinkMiniCluster.");
        this.shutdown();
        this.awaitTermination();
        this.leaderRetrievalService().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LeaderRetrievalService x$4) {
                x$4.stop();
            }
        });
        this.isRunning_$eq(false);
    }

    public void shutdown() {
        this.webMonitor().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(WebMonitor x$5) {
                x$5.stop();
            }
        });
        Seq tmFutures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Seq<Future<Boolean>> apply(Seq<ActorRef> x$6) {
                return (Seq)x$6.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Future<Boolean> apply(ActorRef x$7) {
                        return Patterns$.MODULE$.gracefulStop(x$7, this.$outer.org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer().timeout());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ FlinkMiniCluster org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Seq jmFutures = (Seq)this.jobManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Seq<Future<Boolean>> apply(Seq<ActorRef> x$8) {
                return (Seq)x$8.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Future<Boolean> apply(ActorRef x$9) {
                        return Patterns$.MODULE$.gracefulStop(x$9, this.$outer.org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer().timeout());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ FlinkMiniCluster org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)jmFutures.$plus$plus((GenTraversableOnce)tmFutures, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext()), (Duration)this.timeout());
        if (!this.useSingleActorSystem()) {
            this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Seq<ActorSystem> x$10) {
                    x$10.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ActorSystem x$11) {
                            x$11.shutdown();
                        }
                    });
                }
            });
        }
        this.jobManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$12) {
                x$12.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$13) {
                        x$13.shutdown();
                    }
                });
            }
        });
    }

    public void awaitTermination() {
        this.jobManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$14) {
                x$14.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$15) {
                        x$15.awaitTermination();
                    }
                });
            }
        });
        this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$16) {
                x$16.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$17) {
                        x$17.awaitTermination();
                    }
                });
            }
        });
    }

    public boolean running() {
        return this.isRunning();
    }

    public void waitForTaskManagersToBeRegistered() throws TimeoutException, InterruptedException {
        this.waitForTaskManagersToBeRegistered(this.timeout());
    }

    public void waitForTaskManagersToBeRegistered(FiniteDuration timeout) throws TimeoutException, InterruptedException {
        Seq futures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this, timeout){
            public static final long serialVersionUID = 0L;
            public final FiniteDuration timeout$1;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$18) {
                return (Seq)x$18.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Future<Object> apply(ActorRef taskManager) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(taskManager), (Object)TaskManagerMessages$NotifyWhenRegisteredAtAnyJobManager$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.timeout$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.timeout$1 = timeout$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext()), (Duration)timeout);
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates) throws JobExecutionException {
        return this.submitJobAndWait(jobGraph, printUpdates, this.timeout());
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates, FiniteDuration timeout) {
        return this.submitJobAndWait(jobGraph, printUpdates, timeout, this.createLeaderRetrievalService());
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates, FiniteDuration timeout, LeaderRetrievalService leaderRetrievalService) throws JobExecutionException {
        ActorSystem clientActorSystem = this.startJobClientActorSystem(jobGraph.getJobID());
        try {
            return JobClient.submitJobAndWait(clientActorSystem, leaderRetrievalService, jobGraph, timeout, printUpdates, this.getClass().getClassLoader());
        }
        finally {
            if (!this.useSingleActorSystem()) {
                this.shutdownJobClientActorSystem(clientActorSystem);
            }
        }
    }

    public JobSubmissionResult submitJobDetached(JobGraph jobGraph) throws JobExecutionException {
        ActorGateway jobManagerGateway;
        try {
            jobManagerGateway = this.getLeaderGateway(this.timeout());
        }
        catch (Throwable throwable) {
            throw new JobExecutionException(jobGraph.getJobID(), "Could not retrieve JobManager ActorRef.", throwable);
        }
        JobClient.submitJobDetached(jobManagerGateway, jobGraph, this.timeout(), this.getClass().getClassLoader());
        return new JobSubmissionResult(jobGraph.getJobID());
    }

    public void shutdownJobClientActorSystem(ActorSystem actorSystem) {
        if (!this.useSingleActorSystem()) {
            actorSystem.shutdown();
        }
    }

    public LeaderRetrievalService createLeaderRetrievalService() {
        Tuple2 tuple2 = new Tuple2(this.jobManagerActorSystems(), this.jobManagerActors());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq jmActorSystems = (Seq)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Seq jmActors = (Seq)some2.x();
                    RecoveryMode recoveryMode = this.recoveryMode();
                    RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
                    LeaderRetrievalService leaderRetrievalService = !(recoveryMode != null ? !((Object)((Object)recoveryMode)).equals((Object)recoveryMode2) : recoveryMode2 != null) ? new StandaloneLeaderRetrievalService(AkkaUtils$.MODULE$.getAkkaURL((ActorSystem)jmActorSystems.apply(0), (ActorRef)jmActors.apply(0))) : ZooKeeperUtils.createLeaderRetrievalService(this.configuration());
                    return leaderRetrievalService;
                }
            }
        }
        throw new Exception("The FlinkMiniCluster has not been started properly.");
    }

    public void clearLeader() {
        Object object = this.futureLock();
        synchronized (object) {
            this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.apply());
            this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.apply());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void notifyLeaderAddress(String address, UUID leaderSessionID) {
        if (address == null || address.equals("")) ** GOTO lbl38
        var3_3 = new Tuple2(this.jobManagerActorSystems(), this.jobManagerActors());
        if (var3_3 == null) ** GOTO lbl-1000
        var4_4 = (Option)var3_3._1();
        var5_5 = (Option)var3_3._2();
        if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
        var6_6 = (Some)var4_4;
        systems = (Seq)var6_6.x();
        if (var5_5 instanceof Some) {
            var8_8 = (Some)var5_5;
            actors = (Seq)var8_8.x();
            actorPaths = (Seq)((TraversableLike)((IterableLike)systems.zip((GenIterable)actors, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, ActorRef, Object> apply(Tuple2<Tuple2<ActorSystem, ActorRef>, Object> x0$1) {
                    Tuple2<Tuple2<ActorSystem, ActorRef>, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        if (tuple22 != null) {
                            ActorSystem system = (ActorSystem)tuple22._1();
                            ActorRef actor = (ActorRef)tuple22._2();
                            Tuple3 tuple3 = new Tuple3((Object)AkkaUtils$.MODULE$.getAkkaURL(system, actor), (Object)actor, (Object)BoxesRunTime.boxToInteger((int)index));
                            return tuple3;
                        }
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            var11_11 = actorPaths.find((Function1)new Serializable(this, address){
                public static final long serialVersionUID = 0L;
                private final String address$1;

                public final boolean apply(Tuple3<String, ActorRef, Object> x0$2) {
                    Tuple3<String, ActorRef, Object> tuple3 = x0$2;
                    if (tuple3 != null) {
                        String path = (String)tuple3._1();
                        boolean bl = path.equals(this.address$1);
                        return bl;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    this.address$1 = address$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<ActorRef, Object> apply(Tuple3<String, ActorRef, Object> x) {
                    return new Tuple2(x._2(), x._3());
                }
            });
        } else lbl-1000:
        // 3 sources

        {
            var11_11 = None$.MODULE$;
        }
        selectedLeader = var11_11;
        var13_13 = this.futureLock();
        synchronized (var13_13) {
            block11: {
                block10: {
                    block9: {
                        if (this.leaderGateway().isCompleted()) {
                            this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.apply());
                            this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.apply());
                        }
                        if (!((var14_14 = selectedLeader) instanceof Some) || (var16_16 = (Tuple2)(var15_15 = (Some)var14_14).x()) == null) break block9;
                        leader = (ActorRef)var16_16._1();
                        index = var16_16._2$mcI$sp();
                        this.leaderGateway().success((Object)new AkkaActorGateway(leader, leaderSessionID));
                        var19_19 = this.leaderIndex().success((Object)BoxesRunTime.boxToInteger((int)index));
                        break block10;
                    }
                    v0 = None$.MODULE$;
                    var20_20 = var14_14;
                    if (v0 != null ? v0.equals(var20_20) == false : var20_20 != null) break block11;
                    this.leaderGateway().failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find job manager with address ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address}))));
                    var19_19 = this.leaderIndex().failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find job manager index with address ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address}))));
                }
                return;
            }
            throw new MatchError((Object)var14_14);
        }
    }

    @Override
    public void handleError(Exception exception) {
        Object object = this.futureLock();
        synchronized (object) {
            Promise promise;
            if (this.leaderGateway().isCompleted()) {
                this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.failed((Throwable)exception));
                this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.failed((Throwable)exception));
                promise = BoxedUnit.UNIT;
            } else {
                this.leaderGateway().failure((Throwable)exception);
                promise = this.leaderIndex().failure((Throwable)exception);
            }
            return;
        }
    }

    private final ActorSystem singleActorSystem$lzycompute$1(ObjectRef singleActorSystem$lzy$1, VolatileByteRef bitmap$0$1) {
        FlinkMiniCluster flinkMiniCluster = this;
        synchronized (flinkMiniCluster) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                singleActorSystem$lzy$1.elem = this.startJobManagerActorSystem(0);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (ActorSystem)singleActorSystem$lzy$1.elem;
        }
    }

    public final ActorSystem org$apache$flink$runtime$minicluster$FlinkMiniCluster$$singleActorSystem$1(ObjectRef singleActorSystem$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.singleActorSystem$lzycompute$1(singleActorSystem$lzy$1, bitmap$0$1) : (ActorSystem)singleActorSystem$lzy$1.elem;
    }

    public FlinkMiniCluster(Configuration userConfiguration, boolean useSingleActorSystem) {
        this.userConfiguration = userConfiguration;
        this.useSingleActorSystem = useSingleActorSystem;
        this.LOG = LoggerFactory.getLogger(FlinkMiniCluster.class);
        this.hostname = userConfiguration.getString("jobmanager.rpc.address", InetAddress.getByName("localhost").getHostAddress());
        this.configuration = this.generateConfiguration(userConfiguration);
        this.leaderGateway = Promise$.MODULE$.apply();
        this.leaderIndex = Promise$.MODULE$.apply();
        this.futureLock = new Object();
        this.executionContext = ExecutionContext$.MODULE$.global();
        this.timeout = AkkaUtils$.MODULE$.getTimeout(this.configuration());
        this.recoveryMode = RecoveryMode.fromConfig(this.configuration());
        this.numJobManagers = this.getNumberOfJobManagers();
        this.numTaskManagers = this.configuration().getInteger("local.number-taskmanager", 1);
        this.jobManagerActorSystems = None$.MODULE$;
        this.jobManagerActors = None$.MODULE$;
        this.webMonitor = None$.MODULE$;
        this.taskManagerActorSystems = None$.MODULE$;
        this.taskManagerActors = None$.MODULE$;
        this.leaderRetrievalService = None$.MODULE$;
        this.isRunning = false;
    }
}

