/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceDriver<T>
implements Driver<ReduceFunction<T>, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReduceDriver.class);
    private TaskContext<ReduceFunction<T>, T> taskContext;
    private MutableObjectIterator<T> input;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<ReduceFunction<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<ReduceFunction<T>> getStubType() {
        Class<ReduceFunction> clazz = ReduceFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 1;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.SORTED_REDUCE) {
            throw new Exception("Unrecognized driver strategy for Reduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.comparator = this.taskContext.getDriverComparator(0);
        this.input = this.taskContext.getInput(0);
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ReduceDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("Reducer preprocessing done. Running Reducer code."));
        }
        MutableObjectIterator<T> input = this.input;
        TypeSerializer<T> serializer = this.serializer;
        TypeComparator<T> comparator = this.comparator;
        ReduceFunction<T> function = this.taskContext.getStub();
        Collector<T> output = this.taskContext.getOutputCollector();
        if (this.objectReuseEnabled) {
            Object reuse1 = input.next();
            Object reuse2 = serializer.createInstance();
            Object value = reuse1;
            while (this.running && value != null) {
                Object tmp;
                comparator.setReference(value);
                while ((reuse2 = input.next(reuse2)) != null && comparator.equalToReference(reuse2)) {
                    if ((value = function.reduce(value, reuse2)) != reuse2) continue;
                    tmp = reuse1;
                    reuse1 = reuse2;
                    reuse2 = tmp;
                }
                output.collect(value);
                tmp = reuse1;
                reuse1 = reuse2;
                reuse2 = tmp;
                value = reuse1;
            }
        } else {
            Object value = input.next();
            while (this.running && value != null) {
                comparator.setReference(value);
                Object res = value;
                while ((value = input.next()) != null && comparator.equalToReference(value)) {
                    res = function.reduce(res, value);
                }
                output.collect(res);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

