/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateHandle;
import org.apache.flink.runtime.state.filesystem.FileSerializableStateHandle;

public class FileStreamStateHandle
extends AbstractFileStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = -6826990484549987311L;

    public FileStreamStateHandle(Path filePath) {
        super(filePath);
    }

    @Override
    public InputStream getState(ClassLoader userCodeClassLoader) throws Exception {
        return this.getFileSystem().open(this.getFilePath());
    }

    @Override
    public long getStateSize() throws IOException {
        return this.getFileSize();
    }

    @Override
    public <T extends Serializable> StateHandle<T> toSerializableHandle() {
        return new FileSerializableStateHandle(this.getFilePath());
    }
}

