/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.ArrayDeque;
import java.util.Deque;

public class LRUCache<V> {
    private final Deque<V> lruCache = new ArrayDeque<V>();

    public static <V> LRUCache<V> create() {
        return new LRUCache<V>();
    }

    public void add(V value) {
        this.lruCache.addLast(value);
    }

    public V getLRU() {
        V lru = this.lruCache.pollFirst();
        if (lru != null) {
            this.add(lru);
        }
        return lru;
    }

    public V removeLRU() {
        return this.lruCache.pollFirst();
    }

    public boolean isEmpty() {
        return this.lruCache.isEmpty();
    }

    public int size() {
        return this.lruCache.size();
    }
}

