/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.task;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.util.StringUtils;

public class StringTaskEvent
extends TaskEvent {
    private String message;

    public StringTaskEvent() {
    }

    public StringTaskEvent(String message) {
        this.message = message;
    }

    public String getString() {
        return this.message;
    }

    public void write(DataOutputView out) throws IOException {
        StringUtils.writeNullableString((String)this.message, (DataOutputView)out);
    }

    public void read(DataInputView in) throws IOException {
        this.message = StringUtils.readNullableString((DataInputView)in);
    }

    public int hashCode() {
        if (this.message == null) {
            return 0;
        }
        return this.message.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringTaskEvent)) {
            return false;
        }
        StringTaskEvent ste = (StringTaskEvent)((Object)obj);
        if (this.message == null) {
            return ste.getString() == null;
        }
        return this.message.equals(ste.getString());
    }
}

