/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertexCancelTest;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.ExecutionContext;

public class ExecutionVertexDeploymentTest {
    @Test
    public void testDeployCall() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleActorGateway((ExecutionContext)TestingUtils.directExecutionContext()));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot(slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            try {
                vertex.deployToSlot(slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployWithSynchronousAnswer() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, (ExecutionContext)TestingUtils.directExecutionContext());
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleActorGateway((ExecutionContext)TestingUtils.directExecutionContext()));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot(slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            try {
                vertex.deployToSlot(slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.RUNNING) == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployWithAsynchronousAnswer() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleActorGateway((ExecutionContext)TestingUtils.defaultExecutionContext()));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot(slot);
            try {
                vertex.deployToSlot(slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            try {
                vertex.deployToSlot(slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.RUNNING) == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployFailedSynchronous() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, (ExecutionContext)TestingUtils.directExecutionContext());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleFailingActorGateway((ExecutionContext)TestingUtils.directExecutionContext()));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot(slot);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Assert.assertNotNull((Object)vertex.getFailureCause());
            Assert.assertTrue((boolean)vertex.getFailureCause().getMessage().contains("test_failure_error_message"));
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.FAILED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployFailedAsynchronously() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleFailingActorGateway((ExecutionContext)TestingUtils.directExecutionContext()));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot(slot);
            for (int i = 0; i < 100 && (vertex.getExecutionState() != ExecutionState.FAILED || vertex.getFailureCause() == null); ++i) {
                Thread.sleep(10L);
            }
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Assert.assertNotNull((Object)vertex.getFailureCause());
            Assert.assertTrue((boolean)vertex.getFailureCause().getMessage().contains("test_failure_error_message"));
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.FAILED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFailExternallyDuringDeploy() {
        try {
            JobVertexID jid = new JobVertexID();
            TestingUtils.QueuedActionExecutionContext ec = TestingUtils.queuedActionExecutionContext();
            TestingUtils.ActionQueue queue = ec.actionQueue();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, ec);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionGraphTestUtils.SimpleActorGateway((ExecutionContext)TestingUtils.directExecutionContext()));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot(slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            Exception testError = new Exception("test error");
            vertex.fail((Throwable)testError);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Assert.assertEquals((Object)testError, (Object)vertex.getFailureCause());
            queue.triggerNextAction();
            queue.triggerNextAction();
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.FAILED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFailCallOvertakesDeploymentAnswer() {
        try {
            TestingUtils.QueuedActionExecutionContext context = TestingUtils.queuedActionExecutionContext();
            TestingUtils.ActionQueue queue = context.actionQueue();
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, context);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            ExecutionAttemptID eid = vertex.getCurrentExecutionAttempt().getAttemptId();
            Instance instance = ExecutionGraphTestUtils.getInstance(new ExecutionVertexCancelTest.CancelSequenceActorGateway(context, new TaskMessages.TaskOperationResult(eid, false), new TaskMessages.TaskOperationResult(eid, true)));
            SimpleSlot slot = instance.allocateSimpleSlot(ejv.getJobId());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot(slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            Exception testError = new Exception("test error");
            vertex.fail((Throwable)testError);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Runnable deploy = queue.popNextAction();
            Runnable cancel1 = queue.popNextAction();
            cancel1.run();
            queue.triggerNextAction();
            deploy.run();
            queue.triggerNextAction();
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Assert.assertEquals((Object)testError, (Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.FAILED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)queue.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

