/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import akka.actor.ActorRef;
import akka.dispatch.Futures;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.flink.runtime.instance.ActorGateway;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

public abstract class BaseTestingActorGateway
implements ActorGateway {
    private final ExecutionContext executionContext;

    public BaseTestingActorGateway(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public Future<Object> ask(Object message, FiniteDuration timeout) {
        try {
            final Object result = this.handleMessage(message);
            return Futures.future((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return result;
                }
            }, (ExecutionContext)this.executionContext);
        }
        catch (Exception e) {
            return Futures.future((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    throw e;
                }
            }, (ExecutionContext)this.executionContext);
        }
    }

    public abstract Object handleMessage(Object var1) throws Exception;

    public void tell(Object message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tell(Object message, ActorGateway sender) {
        try {
            this.handleMessage(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void forward(Object message, ActorGateway sender) {
        throw new UnsupportedOperationException();
    }

    public Future<Object> retry(Object message, int numberRetries, FiniteDuration timeout, ExecutionContext executionContext) {
        return this.ask(message, timeout);
    }

    public String path() {
        return "BaseTestingInstanceGateway";
    }

    public ActorRef actor() {
        return ActorRef.noSender();
    }

    public UUID leaderSessionID() {
        return null;
    }
}

