/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.NetUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.impl.Promise;

public class NetworkEnvironmentTest {
    @Test
    public void testAssociateDisassociate() {
        int port;
        int BUFFER_SIZE = 1024;
        int NUM_BUFFERS = 20;
        try {
            port = NetUtils.getAvailablePort();
        }
        catch (Throwable t) {
            return;
        }
        try {
            NettyConfig nettyConf = new NettyConfig(InetAddress.getLocalHost(), port, 1024, 1, new Configuration());
            NetworkEnvironmentConfiguration config = new NetworkEnvironmentConfiguration(20, 1024, MemoryType.HEAP, IOManager.IOMode.SYNC, (Option)new Some((Object)nettyConf), new Tuple2((Object)0, (Object)0));
            NetworkEnvironment env = new NetworkEnvironment((ExecutionContext)TestingUtils.defaultExecutionContext(), new FiniteDuration(30L, TimeUnit.SECONDS), config);
            Assert.assertFalse((boolean)env.isShutdown());
            Assert.assertFalse((boolean)env.isAssociated());
            Assert.assertNotNull((Object)env.getNetworkBufferPool());
            Assert.assertEquals((long)20L, (long)env.getNetworkBufferPool().getTotalNumberOfMemorySegments());
            Assert.assertNull((Object)env.getConnectionManager());
            Assert.assertNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNull((Object)env.getTaskEventDispatcher());
            Assert.assertNull((Object)env.getPartitionManager());
            env.associateWithTaskManagerAndJobManager((ActorGateway)DummyActorGateway.INSTANCE, (ActorGateway)DummyActorGateway.INSTANCE);
            Assert.assertNotNull((Object)env.getConnectionManager());
            Assert.assertNotNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNotNull((Object)env.getTaskEventDispatcher());
            Assert.assertNotNull((Object)env.getPartitionManager());
            BufferPool localPool = env.getNetworkBufferPool().createBufferPool(10, false);
            Assert.assertNotNull((Object)localPool);
            env.disassociate();
            Assert.assertNull((Object)env.getConnectionManager());
            Assert.assertNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNull((Object)env.getTaskEventDispatcher());
            Assert.assertNull((Object)env.getPartitionManager());
            Assert.assertNotNull((Object)env.getNetworkBufferPool());
            Assert.assertTrue((boolean)localPool.isDestroyed());
            env.associateWithTaskManagerAndJobManager((ActorGateway)DummyActorGateway.INSTANCE, (ActorGateway)DummyActorGateway.INSTANCE);
            Assert.assertNotNull((Object)env.getConnectionManager());
            Assert.assertNotNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNotNull((Object)env.getTaskEventDispatcher());
            Assert.assertNotNull((Object)env.getPartitionManager());
            env.shutdown();
            Assert.assertTrue((boolean)env.isShutdown());
            Assert.assertFalse((boolean)env.isAssociated());
            Assert.assertNull((Object)env.getConnectionManager());
            Assert.assertNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNull((Object)env.getTaskEventDispatcher());
            Assert.assertNull((Object)env.getPartitionManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEagerlyDeployConsumers() throws Exception {
        ActorGateway jobManager = (ActorGateway)Mockito.mock(ActorGateway.class);
        Mockito.when((Object)jobManager.ask(Matchers.anyObject(), (FiniteDuration)Matchers.any(FiniteDuration.class))).thenReturn((Object)new Promise.DefaultPromise().future());
        NetworkEnvironmentConfiguration config = new NetworkEnvironmentConfiguration(20, 1024, MemoryType.HEAP, IOManager.IOMode.SYNC, Some.empty(), new Tuple2((Object)0, (Object)0));
        NetworkEnvironment env = new NetworkEnvironment((ExecutionContext)TestingUtils.defaultExecutionContext(), new FiniteDuration(30L, TimeUnit.SECONDS), config);
        env.associateWithTaskManagerAndJobManager(jobManager, (ActorGateway)DummyActorGateway.INSTANCE);
        JobID jobId = new JobID();
        ResultPartition[] partitions = new ResultPartition[]{NetworkEnvironmentTest.createPartition("p1", jobId, true, env), NetworkEnvironmentTest.createPartition("p2", jobId, false, env)};
        ResultPartitionWriter[] writers = new ResultPartitionWriter[]{new ResultPartitionWriter(partitions[0]), new ResultPartitionWriter(partitions[1])};
        Task mockTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)mockTask.getAllInputGates()).thenReturn((Object)new SingleInputGate[0]);
        Mockito.when((Object)mockTask.getAllWriters()).thenReturn((Object)writers);
        Mockito.when((Object)mockTask.getProducedPartitions()).thenReturn((Object)partitions);
        env.registerTask(mockTask);
        ResultPartitionID eagerPartitionId = partitions[0].getPartitionId();
        ((ActorGateway)Mockito.verify((Object)jobManager, (VerificationMode)Mockito.times((int)1))).ask(Matchers.eq((Object)new JobManagerMessages.ScheduleOrUpdateConsumers(jobId, eagerPartitionId)), (FiniteDuration)Matchers.any(FiniteDuration.class));
    }

    private static ResultPartition createPartition(String name, JobID jobId, boolean eagerlyDeployConsumers, NetworkEnvironment env) {
        return new ResultPartition(name, jobId, new ResultPartitionID(), ResultPartitionType.PIPELINED, eagerlyDeployConsumers, 1, env.getPartitionManager(), env.getPartitionConsumableNotifier(), (IOManager)Mockito.mock(IOManager.class), env.getDefaultIOMode());
    }
}

