/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class TestingLeaderRetrievalService
implements LeaderRetrievalService {
    private volatile String leaderAddress;
    private volatile UUID leaderSessionID;
    private volatile LeaderRetrievalListener listener;

    public TestingLeaderRetrievalService() {
        this(null, null);
    }

    public TestingLeaderRetrievalService(String leaderAddress, UUID leaderSessionID) {
        this.leaderAddress = leaderAddress;
        this.leaderSessionID = leaderSessionID;
    }

    public void start(LeaderRetrievalListener listener) throws Exception {
        this.listener = (LeaderRetrievalListener)Preconditions.checkNotNull((Object)listener);
        if (this.leaderAddress != null) {
            listener.notifyLeaderAddress(this.leaderAddress, this.leaderSessionID);
        }
    }

    public void stop() throws Exception {
    }

    public void notifyListener(String address, UUID leaderSessionID) {
        this.leaderAddress = address;
        this.leaderSessionID = leaderSessionID;
        if (this.listener != null) {
            this.listener.notifyLeaderAddress(address, leaderSessionID);
        }
    }
}

