/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.scope.JobManagerScopeFormat;
import org.junit.Assert;
import org.junit.Test;

public class JobManagerGroupTest {
    @Test
    public void addAndRemoveJobs() {
        JobManagerMetricGroup group = new JobManagerMetricGroup(new MetricRegistry(new Configuration()), "localhost");
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobManagerJobMetricGroup jmJobGroup11 = group.addJob(new JobGraph(jid1, "testjob"));
        JobManagerJobMetricGroup jmJobGroup12 = group.addJob(new JobGraph(jid1, "testjob"));
        JobManagerJobMetricGroup jmJobGroup21 = group.addJob(new JobGraph(jid2, "anotherJob"));
        Assert.assertEquals((Object)jmJobGroup11, (Object)jmJobGroup12);
        Assert.assertEquals((long)2L, (long)group.numRegisteredJobMetricGroups());
        group.removeJob(jid1);
        Assert.assertTrue((boolean)jmJobGroup11.isClosed());
        Assert.assertEquals((long)1L, (long)group.numRegisteredJobMetricGroups());
        group.removeJob(jid2);
        Assert.assertTrue((boolean)jmJobGroup21.isClosed());
        Assert.assertEquals((long)0L, (long)group.numRegisteredJobMetricGroups());
    }

    @Test
    public void testCloseClosesAll() {
        JobManagerMetricGroup group = new JobManagerMetricGroup(new MetricRegistry(new Configuration()), "localhost");
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobManagerJobMetricGroup jmJobGroup11 = group.addJob(new JobGraph(jid1, "testjob"));
        JobManagerJobMetricGroup jmJobGroup21 = group.addJob(new JobGraph(jid2, "anotherJob"));
        group.close();
        Assert.assertTrue((boolean)jmJobGroup11.isClosed());
        Assert.assertTrue((boolean)jmJobGroup21.isClosed());
    }

    @Test
    public void testGenerateScopeDefault() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        JobManagerMetricGroup group = new JobManagerMetricGroup(registry, "localhost");
        Assert.assertArrayEquals((Object[])new String[]{"localhost", "jobmanager"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"localhost.jobmanager.name", (Object)group.getMetricIdentifier("name"));
    }

    @Test
    public void testGenerateScopeCustom() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        JobManagerScopeFormat format = new JobManagerScopeFormat("constant.<host>.foo.<host>");
        JobManagerMetricGroup group = new JobManagerMetricGroup(registry, format, "host");
        Assert.assertArrayEquals((Object[])new String[]{"constant", "host", "foo", "host"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"constant.host.foo.host.name", (Object)group.getMetricIdentifier("name"));
    }
}

