/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.scope.JobManagerJobScopeFormat;
import org.apache.flink.runtime.metrics.scope.JobManagerScopeFormat;
import org.junit.Assert;
import org.junit.Test;

public class JobManagerJobGroupTest {
    @Test
    public void testGenerateScopeDefault() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        JobManagerMetricGroup tmGroup = new JobManagerMetricGroup(registry, "theHostName");
        JobManagerJobMetricGroup jmGroup = new JobManagerJobMetricGroup(registry, tmGroup, new JobID(), "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "jobmanager", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.jobmanager.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
    }

    @Test
    public void testGenerateScopeCustom() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        JobManagerScopeFormat tmFormat = new JobManagerScopeFormat("abc");
        JobManagerJobScopeFormat jmFormat = new JobManagerJobScopeFormat("some-constant.<job_name>", tmFormat);
        JobID jid = new JobID();
        JobManagerMetricGroup tmGroup = new JobManagerMetricGroup(registry, "theHostName");
        JobManagerJobMetricGroup jmGroup = new JobManagerJobMetricGroup(registry, tmGroup, jmFormat, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"some-constant", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"some-constant.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
    }

    @Test
    public void testGenerateScopeCustomWildcard() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        JobManagerScopeFormat tmFormat = new JobManagerScopeFormat("peter");
        JobManagerJobScopeFormat jmFormat = new JobManagerJobScopeFormat("*.some-constant.<job_id>", tmFormat);
        JobID jid = new JobID();
        JobManagerMetricGroup tmGroup = new JobManagerMetricGroup(registry, tmFormat, "theHostName");
        JobManagerJobMetricGroup jmGroup = new JobManagerJobMetricGroup(registry, tmGroup, jmFormat, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"peter", "some-constant", jid.toString()}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)("peter.some-constant." + jid + ".name"), (Object)jmGroup.getMetricIdentifier("name"));
    }
}

